/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "preset";
    private static final ConcurrentHashMap<class_2960, Path> presetResourceLocationMap = new ConcurrentHashMap();

    private WorldPresetDataFiles() {
    }

    public static Path getPresetDataFolder() {
        File worldDataFolder = new File(Constants.WORLD_DIR.toFile(), "easy_npc");
        Path path = worldDataFolder.toPath().resolve(DATA_FOLDER_NAME);
        if (!path.toFile().exists() && !path.toFile().mkdirs()) {
            log.error("Could not create preset data folder {}!", (Object)path);
        }
        return path;
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
        String skinModelName = skinModel.name();
        if (!skinModelName.isEmpty()) {
            Path path = presetDataFolder.resolve(skinModelName.toLowerCase(Locale.ROOT));
            if (!path.toFile().exists() && !path.toFile().mkdirs()) {
                log.error("Could not create preset model folder {}!", (Object)path);
            }
            return path;
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = WorldPresetDataFiles.getPresetDataFolder(skinModel);
        if (presetModelFolder != null && fileName != null && !fileName.isEmpty()) {
            return presetModelFolder.resolve(WorldPresetDataFiles.getPresetFileName(fileName)).toFile();
        }
        return null;
    }

    public static String getPresetFileName(String fileName) {
        return CustomPresetDataFiles.getPresetFileName(fileName);
    }

    public static Stream<class_2960> getPresetResourceLocations() {
        Stream<class_2960> stream;
        block8: {
            Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
            Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);
            try {
                List<class_2960> filePaths = filesStream.filter(path -> path.toString().endsWith(".npc.nbt")).filter(path -> Pattern.matches("[a-zA-Z0-9/._-]+", path.getFileName().toString())).map(path -> {
                    class_2960 resourceLocation = class_2960.method_60655((String)"easy_npc", (String)("preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/").toLowerCase(Locale.ROOT)));
                    presetResourceLocationMap.put(resourceLocation, (Path)path);
                    return resourceLocation;
                }).toList();
                stream = filePaths.stream();
                if (filesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    log.error("Could not read world preset data folder {}:", (Object)presetDataFolder, (Object)exception);
                    return Stream.empty();
                }
            }
            filesStream.close();
        }
        return stream;
    }

    public static Path getPresetsResourceLocationPath(class_2960 resourceLocation) {
        return presetResourceLocationMap.get(resourceLocation);
    }
}

