/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.client.pose.PoseManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.PoseSuggestions;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2960;

public class PoseCommand
extends Command {
    private PoseCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pose").requires(commandSource -> commandSource.method_9259(0))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.resetPose((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests(PoseSuggestions::suggest).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.setPose((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2232.method_9443((CommandContext)context, (String)"type"))))));
    }

    private static int resetPose(class_2168 context, EasyNPC<?> easyNPC) {
        PoseManager.resetModelPose(easyNPC);
        return PoseCommand.sendSuccessMessage(context, "Resetting pose for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
    }

    private static int setPose(class_2168 context, EasyNPC<?> easyNPC, class_2960 resourceLocation) {
        AnimationData.Animation animation = PoseManager.getPoseData(resourceLocation);
        if (animation == null) {
            return PoseCommand.sendFailureMessage(context, "Pose " + String.valueOf(resourceLocation) + " was not found!");
        }
        if (PoseManager.setModelPose(easyNPC, animation)) {
            return PoseCommand.sendSuccessMessage(context, "Setting pose " + String.valueOf(resourceLocation) + " for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
        }
        return PoseCommand.sendFailureMessage(context, "Failed to set pose " + String.valueOf(resourceLocation) + " for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
    }
}

