/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import de.markusbordihn.easynpc.config.Config;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RenderEntityTypeSupportConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "render_entity_type_support.cfg";
    public static final String CONFIG_FILE_HEADER = "Render Entity Type Support Configuration\n\n Please note that this configuration file only includes confirmed entity types.\n If an entity type is not listed here, it doesn't mean it's automatically supported or unsupported!\n";
    private static final Set<String> knownUnsupportedEntityTypes = new HashSet<String>(List.of("minecraft:area_effect_cloud", "minecraft:armor_stand", "minecraft:arrow", "minecraft:bat", "minecraft:boat", "minecraft:chest_minecart", "minecraft:command_block_minecart", "minecraft:dragon_fireball", "minecraft:egg", "minecraft:end_crystal", "minecraft:ender_pearl", "minecraft:ender_dragon", "minecraft:evoker_fangs", "minecraft:experience_bottle", "minecraft:experience_orb", "minecraft:eye_of_ender", "minecraft:falling_block", "minecraft:fireball", "minecraft:firework_rocket", "minecraft:fishing_bobber", "minecraft:furnace_minecart", "minecraft:ghast", "minecraft:glow_item_frame", "minecraft:hopper_minecart", "minecraft:item", "minecraft:item_frame", "minecraft:leash_knot", "minecraft:lightning_bolt", "minecraft:llama_spit", "minecraft:marker", "minecraft:magma_cube", "minecraft:minecart", "minecraft:phantom", "minecraft:player", "minecraft:painting", "minecraft:potion", "minecraft:shulker_bullet", "minecraft:small_fireball", "minecraft:snowball", "minecraft:spawner_minecart", "minecraft:spectral_arrow", "minecraft:slime", "minecraft:text_display", "minecraft:tnt", "minecraft:tnt_minecart", "minecraft:trident", "minecraft:wither_skull"));
    private static final Set<String> knownSupportedEntityTypes = new HashSet<String>(List.of("minecraft:axolotl", "minecraft:bee", "minecraft:blaze", "minecraft:cat", "minecraft:cave_spider", "minecraft:chicken", "minecraft:cod", "minecraft:cow", "minecraft:creeper", "minecraft:dolphin", "minecraft:donkey", "minecraft:drowned", "minecraft:elder_guardian", "minecraft:enderman", "minecraft:endermite", "minecraft:evoker", "minecraft:fox", "minecraft:giant", "minecraft:glow_squid", "minecraft:goat", "minecraft:guardian", "minecraft:hoglin", "minecraft:horse", "minecraft:husk", "minecraft:illusioner", "minecraft:iron_golem", "minecraft:llama", "minecraft:mooshroom", "minecraft:mule", "minecraft:ocelot", "minecraft:panda", "minecraft:parrot", "minecraft:pig", "minecraft:piglin", "minecraft:piglin_brute", "minecraft:pillager", "minecraft:polar_bear", "minecraft:pufferfish", "minecraft:rabbit", "minecraft:ravager", "minecraft:salmon", "minecraft:sheep", "minecraft:shulker", "minecraft:silverfish", "minecraft:skeleton", "minecraft:skeleton_horse", "minecraft:snow_golem", "minecraft:spider", "minecraft:squid", "minecraft:stray", "minecraft:strider", "minecraft:trader_llama", "minecraft:tropical_fish", "minecraft:turtle", "minecraft:vex", "minecraft:villager", "minecraft:vindicator", "minecraft:wandering_trader", "minecraft:witch", "minecraft:wither", "minecraft:wither_skeleton", "minecraft:wolf", "minecraft:zoglin", "minecraft:zombie", "minecraft:zombie_horse", "minecraft:zombie_villager", "minecraft:zombified_piglin"));
    private static final Set<String> knownUnsupportedThirdPartyEntityTypes = new HashSet<String>(List.of("ad_astra:ice_spit", "ad_astra:lander", "ad_astra:space_painting", "ad_astra:tier_1_rocket", "ad_astra:tier_1_rover", "ad_astra:tier_2_rocket", "ad_astra:tier_3_rocket", "ad_astra:tier_4_rocket", "ae2:tiny_tnt_primed", "alexsmobs:cachalot_echo", "alexsmobs:centipede_body", "alexsmobs:centipede_tail", "alexsmobs:cockroach_egg", "alexsmobs:cosmic_cod", "alexsmobs:emu_egg", "alexsmobs:enderiophage_rocket", "alexsmobs:gust", "alexsmobs:hemolymph", "alexsmobs:ice_shard", "alexsmobs:mosquito_spit", "alexsmobs:sand_shot", "alexsmobs:squid_grapple", "alexsmobs:straddleboard", "alexsmobs:tossed_item", "alexsmobs:vine_lasso", "alexsmobs:void_portal", "alexsmobs:void_worm_shot", "apexcore:seat", "aquamirae:maze_rose", "aquamirae:pillagers_patrol", "aquamirae:pillagers_patrol", "aquamirae:poisoned_chakra", "armourers_workshop:mannequin", "ba_bt:core_monolith", "ba_bt:core_obelisk", "ba_bt:end_monolith", "ba_bt:end_obelisk", "ba_bt:explosion_physics", "ba_bt:land_destruction", "ba_bt:land_monolith", "ba_bt:land_obelisk", "ba_bt:nether_monolith", "ba_bt:nether_obelisk", "ba_bt:ocean_destruction", "ba_bt:ocean_monolith", "ba_bt:ocean_obelisk", "ba_bt:sky_monolith", "ba_bt:sky_obelisk", "biomemakeover:blightbat", "biomemakeover:lightning_bottle", "biomemakeover:tumbleweed", "bloodandmadness:augur_of_ebrietas", "bloodandmadness:binding_spell", "bloodandmadness:blossomed_eye", "bloodandmadness:bullet", "bloodandmadness:call_beyond_aim_helper", "bloodandmadness:call_beyond", "bloodandmadness:flame", "bloodandmadness:red_jewel", "blue_skies:boss_item", "blue_skies:decaying_spike", "blue_skies:ent_leaf", "blue_skies:ent_root", "blue_skies:ent_wall", "blue_skies:fluctuant_sphere", "blue_skies:frost_spirit", "blue_skies:nyctofly", "blue_skies:seed_bomb", "blue_skies:spear", "blue_skies:strange_lightning", "blue_skies:venom_bomb", "blue_skies:venom_spit", "blueprint:boat", "bosses_of_mass_destruction:charged_ender_pearl", "bosses_of_mass_destruction:comet", "bosses_of_mass_destruction:petal_blade", "bosses_of_mass_destruction:soul_star", "botania:babylon_weapon", "botania:corporea_spark", "botania:doppleganger", "botania:ender_air_bottle", "botania:ender_air", "botania:falling_star", "botania:flame_ring", "botania:magic_landmine", "botania:magic_missile", "botania:mana_burst", "botania:mana_storm", "botania:pixie", "botania:player_mover", "botania:pool_minecart", "botania:spark", "botania:thorn_chakram", "botania:thrown_item", "braincell:boat", "brutalbosses:thrownitem", "bygonenether:warped_ender_pearl", "cataclysm:ashen_breath", "cataclysm:blazing_bone", "cataclysm:charge_watcher", "cataclysm:cm_falling_block", "cataclysm:flame_strike", "cataclysm:lava_bomb", "cataclysm:screen_shake", "cataclysm:void_rune", "cataclysm:void_shard", "cataclysm:wall_watcher", "cloudstorage:badloon_hand", "cloudstorage:balloon_cargo", "cloudstorage:balloon_tie", "cloudstorage:balloon", "conjurer_illager:throwing_card", "corpse:corpse", "create:carriage_contraption", "create:contraption", "create:crafting_blueprint", "create:gantry_contraption", "create:seat", "create:stationary_contraption", "create:super_glue", "dannys_expansion:arrow", "dannys_expansion:bullet", "dannys_expansion:ice_spike", "dannys_expansion:klifour_spit", "dannys_expansion:mundane_slime", "dannys_expansion:mundane_slime", "dannys_expansion:squig_bubble", "dannys_expansion:test_dummy", "darkersouls:nameless_king_summons", "darkersouls:wind_no_collision", "dawncraft:fallen", "dawncraft:quest_player", "dawncraft:ritual_item", "difficultraids:frost_snowball", "dragonmounts:dragon_egg", "dummmmmmy:dummy_number", "dummmmmmy:target_dummy", "ecologics:boat", "epicfight:dodge_left", "epicfight:dropped_nether_star", "epicfight:forbidden_strength_orb", "epicfight:wither_ghost", "farmersdelight:rotten_tomato", "friendsandfoes:ice_chunk", "friendsandfoes:player_illusion", "frostiful:freezing_wind", "frostiful:frost_spell", "frostiful:packed_snowball", "frostiful:thrown_icicle", "goblinsanddungeons:falling_block", "graveyard:ghouling", "graveyard:skull", "habitat:boat", "habitat:kabloom_fruit", "handcrafted:fancy_painting", "handcrafted:seat", "hexerei:broom", "hunterillager:boomerang", "illageandspillage:imp", "illageandspillage:soul_beam", "immersive_weathering:falling_icicle", "immersive_weathering:falling_layer", "infernal:flaming_poop", "infernalexp:ascus_bomb", "infernalexp:glowsilk_moth", "infernalexp:infernal_painting", "infernalexp:throwable_brick", "infernalexp:throwable_fire_charge", "infernalexp:throwable_magma_cream", "infernalexp:throwable_nether_brick", "irons_spellbooks:acid_orb", "irons_spellbooks:black_hole", "irons_spellbooks:blood_needle", "irons_spellbooks:comet", "irons_spellbooks:dragon_breath_pool", "irons_spellbooks:fire_field", "irons_spellbooks:fireball", "irons_spellbooks:frozen_humanoid", "irons_spellbooks:healing_aoe", "irons_spellbooks:poison_breath", "irons_spellbooks:poison_cloud", "irons_spellbooks:poison_splash", "irons_spellbooks:root", "irons_spellbooks:shield", "irons_spellbooks:spectral_hammer", "irons_spellbooks:target_area", "irons_spellbooks:void_tentacle", "irons_spellbooks:wall_of_fire", "lootr:lootr_minecart", "lootr:lootr_minecart", "majruszsdifficulty:cursed_armor", "meetyourfight:swamp_mine", "meetyourfight:swampjaw", "monsterplus:bloody_slash", "monsterplus:crystal_clump", "monsterplus:crystal_spikes", "monsterplus:opalescent_eye", "monsterplus:spike_countdown", "moretotems:summoned_bee", "moretotems:summoned_zombie", "mowziesmobs:block_swapper_sculptor", "mowziesmobs:block_swapper", "mowziesmobs:boulder_platform", "mowziesmobs:camera_shake", "mowziesmobs:dart", "mowziesmobs:falling_block", "mowziesmobs:frozen_controller", "mowziesmobs:ice_breath", "mowziesmobs:pillar_piece", "mowziesmobs:pillar", "mowziesmobs:rock_sling", "mowziesmobs:solar_beam", "mowziesmobs:sunstrike", "mowziesmobs:super_nova", "mutantmonsters:creeper_minion_egg", "mutantmonsters:endersoul_fragment", "mutantmonsters:skull_spirit", "mutantmonsters:throwable_block", "orcz:decaystrikecustom", "orcz:decaystrikecustom", "orcz:wither_strikeringcustom", "quark:chest_passenger", "quark:glass_frame", "quark:gravisand", "quark:parrot_egg", "quark:pickarang", "quark:skull_pike", "quark:soul_bead", "quark:stool", "quark:totem", "restored_earth:melon_seed", "restored_earth:rotten_flesh", "restored_earth:tropical_slime", "revamped_phantoms:shockwave", "savage_and_ravage:burning_banner", "savage_and_ravage:confusion_bolt", "savage_and_ravage:ice_chunk", "savage_and_ravage:ice_cloud", "savage_and_ravage:rune_prison", "savage_and_ravage:spore_bomb", "savage_and_ravage:spore_cloud", "simple_mobs:dragon_smoke", "simple_mobs:elemental_chain", "simple_mobs:ground_spike", "simple_mobs:ground_spike", "simple_mobs:korok_intro", "simple_mobs:lightning_spear", "simple_mobs:projecttest", "simple_mobs:rumble", "simple_mobs:rumble", "simple_mobs:staff_interact", "simple_mobs:staff_usage", "smallships:brigg", "smallships:cog", "smallships:galley", "sophisticatedbackpacks:everlasting_backpack_item", "supplementaries:bomb", "supplementaries:dispenser_minecart", "supplementaries:falling_ash", "supplementaries:falling_lantern", "supplementaries:falling_sack", "supplementaries:falling_urn", "supplementaries:pearl_marker", "swampier_swamps:swamp_gas", "sword_soaring:rain_cutter_sword", "sword_soaring:rain_screen_sword", "sword_soaring:stellar_sword", "sword_soaring:sword", "techreborn:nuke", "terraform:boat", "the_bumblezone:bee_stinger", "the_bumblezone:cosmic_crystal_entity", "the_bumblezone:dirt_pellet", "the_bumblezone:electric_ring_entity", "the_bumblezone:honey_crystal_shard", "the_bumblezone:pollen_puff", "the_bumblezone:purple_spike_entity", "the_bumblezone:sentry_watcher", "the_bumblezone:thrown_stinger_spear", "tumbleweed:tumbleweed", "twigs:pebble", "untamedwilds:spit", "wom:antitheus_darkness", "wom:enderblast"));
    private static final Set<String> knownSupportedThirdPartyEntityTypes = new HashSet<String>(List.of("alexsmobs:alligator_snapping_turtle", "alexsmobs:anaconda", "alexsmobs:anteater", "alexsmobs:bald_eagle", "alexsmobs:bison", "alexsmobs:blobfish", "alexsmobs:bone_serpent", "alexsmobs:bunfungus", "alexsmobs:cachalot_whale", "alexsmobs:capuchin_monkey", "alexsmobs:catfish", "alexsmobs:centipede_head", "alexsmobs:cockroach", "alexsmobs:comb_jelly", "alexsmobs:cosmaw", "alexsmobs:crimson_mosquito", "alexsmobs:crocodile", "alexsmobs:crow", "alexsmobs:devils_hole_pupfish", "alexsmobs:dropbear", "alexsmobs:elephant", "alexsmobs:emu", "alexsmobs:endergrade", "alexsmobs:enderiophage", "alexsmobs:flutter", "alexsmobs:fly", "alexsmobs:flying_fish", "alexsmobs:frilled_shark", "alexsmobs:froststalker", "alexsmobs:gazelle", "alexsmobs:gelada_monkey", "alexsmobs:giant_squid", "alexsmobs:gorilla", "alexsmobs:grizzly_bear", "alexsmobs:guster", "alexsmobs:hammerhead_shark", "alexsmobs:hummingbird", "alexsmobs:jerboa", "alexsmobs:kangaroo", "alexsmobs:komodo_dragon", "alexsmobs:laviathan", "alexsmobs:leafcutter_ant", "alexsmobs:lobster", "alexsmobs:maned_wolf", "alexsmobs:mantis_shrimp", "alexsmobs:mimic_octopus", "alexsmobs:mimicube", "alexsmobs:moose", "alexsmobs:mungus", "alexsmobs:orca", "alexsmobs:platypus", "alexsmobs:raccoon", "alexsmobs:rattlesnake", "alexsmobs:roadrunner", "alexsmobs:rocky_roller", "alexsmobs:sea_bear", "alexsmobs:seagull", "alexsmobs:seal", "alexsmobs:shoebill", "alexsmobs:skelewag", "alexsmobs:snow_leopard", "alexsmobs:soul_vulture", "alexsmobs:spectre", "alexsmobs:straddler", "alexsmobs:stradpole", "alexsmobs:sunbird", "alexsmobs:tarantula_hawk", "alexsmobs:tasmanian_devil", "alexsmobs:terrapin", "alexsmobs:tiger", "alexsmobs:toucan", "alexsmobs:tusklin", "alexsmobs:void_worm", "alexsmobs:warped_mosco", "alexsmobs:warped_toad", "aquamirae:anglerfish", "aquamirae:captain_cornelia", "aquamirae:eel", "aquamirae:golden_moth", "aquamirae:luminous_jelly", "aquamirae:maw", "aquamirae:maze_mother", "aquamirae:spinefish", "aquamirae:tortured_soul", "ba_bt:bt_cultist", "ba_bt:core_golem", "ba_bt:end_golem", "ba_bt:land_golem", "ba_bt:nether_golem", "ba_bt:ocean_golem", "ba_bt:platinum_skeleton", "ba_bt:sky_golem", "ba_bt:sky_minion", "biomemakeover:adjudicator_mimic", "biomemakeover:adjudicator", "biomemakeover:cowboy", "biomemakeover:decayed", "biomemakeover:dragonfly", "biomemakeover:ghost", "biomemakeover:glowfish", "biomemakeover:lightning_bug_alternate", "biomemakeover:lightning_bug", "biomemakeover:moth", "biomemakeover:mushroom_trader", "biomemakeover:owl", "biomemakeover:rootling", "biomemakeover:scuttler", "biomemakeover:stone_golem", "biomemakeover:tadpole", "biomemakeover:toad", "bloodandmadness:ashen_blood_beast_patient", "bloodandmadness:beast_patient", "bloodandmadness:brainsucker", "bloodandmadness:celestial_emissary", "bloodandmadness:church_doctor_crucifix", "bloodandmadness:church_doctor_flamesprayer", "bloodandmadness:church_doctor_lantern", "bloodandmadness:church_doctor_pistol", "bloodandmadness:church_doctor_scythe", "bloodandmadness:church_doctor", "bloodandmadness:cloaked_beast_patient", "bloodandmadness:father_gascoigne", "bloodandmadness:gascoigne_beast", "bloodandmadness:huntsman_axe", "bloodandmadness:huntsman_cutlass", "bloodandmadness:micolash", "bloodandmadness:silverbeast", "bloodandmadness:skeletal_puppet", "blue_skies:alchemist", "blue_skies:arachnarch", "blue_skies:armored_frost_spirit", "blue_skies:artificial_golem", "blue_skies:azulfo", "blue_skies:charscale_moki", "blue_skies:cosmic_fox", "blue_skies:crogre", "blue_skies:crynocerous", "blue_skies:crystal_camel", "blue_skies:diophyde_prowler", "blue_skies:emberback", "blue_skies:firefly", "blue_skies:gatekeeper", "blue_skies:grittle_flatfish", "blue_skies:horizofin_tunid", "blue_skies:infested_swarmer", "blue_skies:jelly_drifter", "blue_skies:municipal_monkfish", "blue_skies:nested_spider", "blue_skies:polargeist", "blue_skies:reindeer", "blue_skies:seclam", "blue_skies:shade_monitor", "blue_skies:shrumpty", "blue_skies:sliv", "blue_skies:snow_owl", "blue_skies:spewter", "blue_skies:stardust_ram", "blue_skies:starlit_crusher", "blue_skies:stonelet", "blue_skies:summoner", "blue_skies:supporter_pet", "blue_skies:venom_spider", "blue_skies:whistleshell_crab", "bosses_of_mass_destruction:gauntlet", "bosses_of_mass_destruction:lich", "bosses_of_mass_destruction:obsidilith", "bosses_of_mass_destruction:void_blossom", "bygonenether:corpor", "bygonenether:piglin_hunter", "bygonenether:piglin_prisoner", "bygonenether:warped_enderman", "bygonenether:wex", "bygonenether:wither_skeleton_horse", "bygonenether:wither_skeleton_knight", "bygonenether:wraither", "cataclysm:ender_golem", "cataclysm:ender_guardian", "cataclysm:endermaptera", "cataclysm:ignis", "cataclysm:ignited_revenant", "cataclysm:nameless_sorcerer", "cataclysm:netherite_monstrosity", "cloudstorage:badloon", "cloudstorage:balloon_buddy", "cloudstorage:bloviator", "conjurer_illager:conjurer", "creeperoverhaul:badlands_creeper", "creeperoverhaul:bamboo_creeper", "creeperoverhaul:beach_creeper", "creeperoverhaul:cave_creeper", "creeperoverhaul:dark_oak_creeper", "creeperoverhaul:desert_creeper", "creeperoverhaul:dripstone_creeper", "creeperoverhaul:hills_creeper", "creeperoverhaul:jungle_creeper", "creeperoverhaul:mushroom_creeper", "creeperoverhaul:savannah_creeper", "creeperoverhaul:snowy_creeper", "creeperoverhaul:spruce_creeper", "creeperoverhaul:swamp_creeper", "dannys_expansion:cursed_skull", "dannys_expansion:desertic_slime", "dannys_expansion:floam", "dannys_expansion:foamcaster", "dannys_expansion:foamie", "dannys_expansion:foamspring", "dannys_expansion:ghoul", "dannys_expansion:goblin", "dannys_expansion:hollow_armor", "dannys_expansion:hollowlet", "dannys_expansion:ice_elemental", "dannys_expansion:klifour", "dannys_expansion:magma_slime", "dannys_expansion:monstrous_scorpion", "dannys_expansion:squig", "darkersouls:nameless_king", "dawncraft:knight_player", "difficultraids:assassin_illager", "difficultraids:dart_illager", "difficultraids:electro_illager", "difficultraids:frost_illager", "difficultraids:modur_elite", "difficultraids:necromancer_illager", "difficultraids:nuaos_elite", "difficultraids:shaman_illager", "difficultraids:tank_illager", "difficultraids:voldon_elite", "difficultraids:voldon_familiar", "difficultraids:warrior_illager", "difficultraids:xydrax_elite", "dragonmounts:dragon", "ecologics:camel", "ecologics:coconut_crab", "ecologics:penguin", "ecologics:squirrel", "enlightened_end:big_ringling", "enlightened_end:stalker", "epicfight:wither_skeleton_minion", "friendsandfoes:copper_golem", "friendsandfoes:glare", "friendsandfoes:iceologer", "friendsandfoes:mauler", "friendsandfoes:moobloom", "goblinsanddungeons:garch", "goblinsanddungeons:gob", "goblinsanddungeons:gobber", "goblinsanddungeons:goblin_king", "goblinsanddungeons:goblo", "goblinsanddungeons:goom", "goblinsanddungeons:hobgob", "goblinsanddungeons:mimic", "goblinsanddungeons:ogre", "goblintraders:goblin_trader", "goblintraders:vein_goblin_trader", "guardvillagers:guard", "habitat:passerine", "habitat:pooka", "hexerei:crow", "humancompanions:arbalist", "humancompanions:archer", "humancompanions:axeguard", "humancompanions:knight", "hunterillager:hunterillager", "illageandspillage:boss_randomizer", "illageandspillage:crashager", "illageandspillage:dispenser", "illageandspillage:faker", "illageandspillage:igniter", "illageandspillage:illager_soul", "illageandspillage:illashooter", "illageandspillage:magispeller", "illageandspillage:mob_spirit", "illageandspillage:spirit_hand", "illageandspillage:spiritcaller", "illageandspillage:twittollager", "infernalexp:basalt_giant", "infernalexp:blackstone_dwarf", "infernalexp:blindsight", "infernalexp:embody", "infernalexp:glowsquito", "infernalexp:shroomloin", "infernalexp:voline", "infernalexp:warpbeetle", "irons_spellbooks:archevoker", "irons_spellbooks:catacombs_zombie", "irons_spellbooks:citadel_keeper", "irons_spellbooks:cryomancer", "irons_spellbooks:dead_king_corpse", "irons_spellbooks:dead_king", "irons_spellbooks:debug_wizard", "irons_spellbooks:magehunter_vindicator", "irons_spellbooks:necromancer", "irons_spellbooks:pyromancer", "irons_spellbooks:spectral_steed", "irons_spellbooks:summoned_polar_bear", "irons_spellbooks:summoned_skeleton", "irons_spellbooks:summoned_vex", "irons_spellbooks:summoned_zombie", "irons_spellbooks:wisp", "kobolds:kobold_captain", "kobolds:kobold_child", "kobolds:kobold_enchanter", "kobolds:kobold_engineer", "kobolds:kobold_pirate", "kobolds:kobold_rascal", "kobolds:kobold_skeleton", "kobolds:kobold_warrior", "kobolds:kobold_zombie", "kobolds:kobold", "lilwings:aponi_butterfly", "lilwings:butter_gold_butterfly", "lilwings:cloudy_puff_butterfly", "lilwings:crystal_puff_butterfly", "lilwings:gold_applefly_butterfly", "lilwings:grayling_butterfly", "lilwings:painted_panther_butterfly", "lilwings:red_applefly_butterfly", "lilwings:shroom_skipper_butterfly", "lilwings:swallow_tail_butterfly", "lilwings:swamp_hopper_butterfly", "lilwings:white_fox_butterfly", "majruszsdifficulty:cerberus", "majruszsdifficulty:creeperling", "majruszsdifficulty:giant", "majruszsdifficulty:tank", "meetyourfight:bellringer", "meetyourfight:dame_fortuna", "mimic:mimic", "monsterplus:abyssologer", "monsterplus:crystal_zombie", "monsterplus:glow_skeleton", "monsterplus:lava_squid", "monsterplus:mother_lava_squid", "monsterplus:overgrown_skeleton", "monsterplus:spectral_skeleton", "monsterplus:swamp_zombie", "mowziesmobs:baby_foliaath", "mowziesmobs:ferrous_wroughtnaut", "mowziesmobs:foliaath", "mowziesmobs:frostmaw", "mowziesmobs:grottol", "mowziesmobs:lantern", "mowziesmobs:naga", "mowziesmobs:umvuthana_crane_player", "mowziesmobs:umvuthana_crane", "mowziesmobs:umvuthana_follower_player", "mowziesmobs:umvuthana_follower_raptor", "mowziesmobs:umvuthana_raptor", "mowziesmobs:umvuthana", "mowziesmobs:umvuthi", "mutantmonsters:creeper_minion", "mutantmonsters:endersoul_clone", "mutantmonsters:mutant_creeper", "mutantmonsters:mutant_enderman", "mutantmonsters:mutant_skeleton", "mutantmonsters:mutant_snow_golem", "mutantmonsters:mutant_zombie", "mutantmonsters:spider_pig", "netherskeletons:basalt_skeleton", "netherskeletons:charred_skeleton", "netherskeletons:crimson_skeleton", "netherskeletons:crying_obby_skeleton", "netherskeletons:nether_skeleton", "netherskeletons:skelly_ghast", "netherskeletons:soul_skeleton", "netherskeletons:warped_skeleton", "ob_core:ancient_paladin", "ob_core:hilda", "ob_core:obsidian_shard", "orcz:bigorcboss", "orcz:decaystrike", "orcz:goblin_2sword", "orcz:goblincammo", "orcz:goblinsavagebomb", "orcz:goblinsavagemace", "orcz:goblinshield", "orcz:goblinwerid", "orcz:orcirongroupleader", "orcz:orcsavage_2sword", "orcz:orcsavage_2swordiron", "orcz:orcsavagegroupleader", "orcz:orcsavagemace", "orcz:orcsavagemaceiron", "orcz:orcsavageweird", "orcz:orcshield", "orcz:orcshieldiron", "orcz:savagegoblin", "orcz:savageorc", "orcz:savageorciron", "orcz:spectre_squig", "orcz:squig", "orcz:weirdboinecro", "orcz:witherstrikering", "piglinproliferation:piglin_alchemist", "progressivebosses:larva", "progressivebosses:wither_minion", "quark:crab", "quark:forgotten", "quark:foxhound", "quark:frog", "quark:shiba", "quark:stoneling", "quark:toretoise", "quark:wraith", "quest_giver:quest_guard_villager", "quest_giver:quest_villager", "restored_earth:bone_spider", "restored_earth:bouldering_zombie", "restored_earth:cluckshroom", "restored_earth:fancy_chicken", "restored_earth:furnace_golem", "restored_earth:jolly_llama", "restored_earth:jumbo_rabbit", "restored_earth:lobber_zombie", "restored_earth:melon_golem", "restored_earth:moobloom", "restored_earth:moolip", "restored_earth:muddy_pig", "restored_earth:rainbow_sheep", "restored_earth:skeleton_wolf", "restored_earth:viler_witch", "restored_earth:wooly_cow", "savage_and_ravage:creepie", "savage_and_ravage:executioner", "savage_and_ravage:griefer", "savage_and_ravage:iceologer", "savage_and_ravage:skeleton_villager", "savage_and_ravage:trickster", "simple_mobs:air", "simple_mobs:asharmor_fire", "simple_mobs:asharmor_ice", "simple_mobs:ball", "simple_mobs:barbarian_1", "simple_mobs:barbarian_2", "simple_mobs:barbarian_3", "simple_mobs:barbarian_4", "simple_mobs:barrel_man", "simple_mobs:blackhole", "simple_mobs:blackmarketvillager", "simple_mobs:blood_splash_1", "simple_mobs:blood_splash_2", "simple_mobs:bone", "simple_mobs:bright_elemental", "simple_mobs:caped_minotaur", "simple_mobs:cave_blockhead", "simple_mobs:cave_dweller", "simple_mobs:cave_golem", "simple_mobs:claw_mark", "simple_mobs:cloaked_villager", "simple_mobs:corrupted_ogre", "simple_mobs:cube", "simple_mobs:cultist", "simple_mobs:damaginglaser", "simple_mobs:dark_elemental", "simple_mobs:darkwerewolf", "simple_mobs:defeating_cube", "simple_mobs:dragging_spell", "simple_mobs:dragon_flame", "simple_mobs:dragon_lightning_breath", "simple_mobs:dragon_lord_stone", "simple_mobs:dragon_lord", "simple_mobs:elemental_deity", "simple_mobs:elemental_grab", "simple_mobs:elemental_shield", "simple_mobs:elemental_spawn", "simple_mobs:ensnared_soul", "simple_mobs:ent", "simple_mobs:fasttravelcircle", "simple_mobs:fire_drag_proj", "simple_mobs:fire_dragon_ambient", "simple_mobs:fire_dragon_grab", "simple_mobs:fire_dragon", "simple_mobs:fire_giant", "simple_mobs:fireball", "simple_mobs:first_twin", "simple_mobs:flame_ball_player", "simple_mobs:gael_wraith_target", "simple_mobs:gael_wraith", "simple_mobs:gael", "simple_mobs:gemspike", "simple_mobs:getsuga_65", "simple_mobs:ghostprojectile", "simple_mobs:giant_skele", "simple_mobs:giant", "simple_mobs:gob", "simple_mobs:gobber", "simple_mobs:goblo", "simple_mobs:goom", "simple_mobs:goop_spit", "simple_mobs:grabbed", "simple_mobs:graywerewolf", "simple_mobs:griffingrab", "simple_mobs:gryphon", "simple_mobs:guardian_eye", "simple_mobs:half_wither_demon", "simple_mobs:herobrine_fear", "simple_mobs:herobrine_flash", "simple_mobs:herobrine_follower", "simple_mobs:herobrine_spike_1", "simple_mobs:herobrine_spike_2", "simple_mobs:herobrine", "simple_mobs:herobrinese_2", "simple_mobs:herobrinese_3", "simple_mobs:herobrinese", "simple_mobs:hobgob", "simple_mobs:ibr_17eem_171", "simple_mobs:ice_dragon_ambient", "simple_mobs:ice_dragon_breath", "simple_mobs:ice_dragon", "simple_mobs:imp_bomb", "simple_mobs:imp_guard", "simple_mobs:imp_melee", "simple_mobs:imp_range", "simple_mobs:josslyn_mc", "simple_mobs:jungharam", "simple_mobs:knight_2", "simple_mobs:knight_3", "simple_mobs:knight_4", "simple_mobs:knight", "simple_mobs:korok_1", "simple_mobs:korok_2", "simple_mobs:korok_3", "simple_mobs:korok_4", "simple_mobs:korok_5_balloon", "simple_mobs:korok_5", "simple_mobs:laser_2", "simple_mobs:lightning_dragon_ambient", "simple_mobs:lightning_dragon", "simple_mobs:liver_cirrhosis", "simple_mobs:lorde_rk", "simple_mobs:lost_eye_ogre", "simple_mobs:losteyeproj", "simple_mobs:manuel_poky", "simple_mobs:martian", "simple_mobs:merlin_1306", "simple_mobs:minotaur", "simple_mobs:monika_sunrise", "simple_mobs:monk", "simple_mobs:moon_slash_1", "simple_mobs:moon_slash_2", "simple_mobs:morgott", "simple_mobs:moss_golem", "simple_mobs:multipartbody_2", "simple_mobs:multipartbody", "simple_mobs:nine_tails", "simple_mobs:ninja", "simple_mobs:notch_boss", "simple_mobs:notch_grab", "simple_mobs:notch_punch", "simple_mobs:notch_sit", "simple_mobs:ogre", "simple_mobs:omen_clone", "simple_mobs:patronwerewolf", "simple_mobs:ppx", "simple_mobs:protector", "simple_mobs:raiddetectwitch", "simple_mobs:rat_mid", "simple_mobs:rat_small", "simple_mobs:roar", "simple_mobs:rod_particles", "simple_mobs:samurai_1", "simple_mobs:samurai_2", "simple_mobs:samurai_4", "simple_mobs:samurai_5", "simple_mobs:samurai_placeholder", "simple_mobs:sand_wyrm", "simple_mobs:second_twin", "simple_mobs:sentinel_flash", "simple_mobs:sentinel_knight", "simple_mobs:sentinel_slash", "simple_mobs:shade", "simple_mobs:shadow_clone", "simple_mobs:shadow_mew_yt", "simple_mobs:shadow", "simple_mobs:shield_element", "simple_mobs:shielded_skeleton", "simple_mobs:shogunate_ghost", "simple_mobs:skeleton_demon", "simple_mobs:skeletonlord", "simple_mobs:solar_pixel", "simple_mobs:souls_summon_2", "simple_mobs:souls_summon", "simple_mobs:spawn_protect", "simple_mobs:sphere", "simple_mobs:spikes", "simple_mobs:spiritnick", "simple_mobs:sprout", "simple_mobs:summon_drag", "simple_mobs:sword_auto_2", "simple_mobs:sword_auto", "simple_mobs:tail_dart", "simple_mobs:tiny_necromancer", "simple_mobs:toxic_goop", "simple_mobs:tracking_thunder", "simple_mobs:tree_drain_particles", "simple_mobs:twins_stone", "simple_mobs:u_gone", "simple_mobs:vampire", "simple_mobs:weak_ogre", "simple_mobs:whisperer_stem_2", "simple_mobs:whisperer_stem", "simple_mobs:whisperer", "simple_mobs:wind", "simple_mobs:wither_demon", "simple_mobs:wither_ray", "simple_mobs:woodenday", "simple_mobs:yes_im_david", "supplementaries:red_merchant", "tinyskeletons:baby_skeleton", "tinyskeletons:baby_stray", "tinyskeletons:baby_wither_skeleton", "undead_revamp2:axestrom", "undead_revamp2:bomber", "undead_revamp2:crackleball", "undead_revamp2:flame", "undead_revamp2:invisiblebidy", "undead_revamp2:slaveman", "undead_revamp2:sucker", "undead_revamp2:the_moonflower", "undead_revamp2:thebeartamer", "undead_revamp2:thebidy", "undead_revamp2:thebidyupside", "undead_revamp2:thehorrors", "undead_revamp2:thehorrorsdecoys", "undead_revamp2:thehunter", "undead_revamp2:theordure", "undead_revamp2:thepregnant", "undead_revamp2:therod", "undead_revamp2:thesmoker", "undead_revamp2:thespectre", "undead_revamp2:thespitter", "undead_revamp2:theswarmer", "undead_revamp2:thewolf", "untamedwilds:aardvark", "untamedwilds:arowana", "untamedwilds:baleen_whale", "untamedwilds:bear", "untamedwilds:big_cat", "untamedwilds:bison", "untamedwilds:boar", "untamedwilds:butterfly", "untamedwilds:camel", "untamedwilds:catfish", "untamedwilds:football_fish", "untamedwilds:giant_clam", "untamedwilds:giant_salamander", "untamedwilds:hippo", "untamedwilds:hyena", "untamedwilds:king_crab", "untamedwilds:large_snake", "untamedwilds:manatee", "untamedwilds:monitor", "untamedwilds:newt", "untamedwilds:opossum", "untamedwilds:rhino", "untamedwilds:sawfish", "untamedwilds:shark", "untamedwilds:snake", "untamedwilds:softshell_turtle", "untamedwilds:spadefish", "untamedwilds:spitter", "untamedwilds:sunfish", "untamedwilds:tarantula", "untamedwilds:terror_bird", "untamedwilds:tortoise", "untamedwilds:trevally", "untamedwilds:triggerfish", "untamedwilds:whale_shark", "untamedwilds:wildebeest", "wildbackport:allay", "wildbackport:frog", "wildbackport:tadpole", "wildbackport:warden"));
    private static final Set<String> supportedEntityTypes = new HashSet<String>();
    private static final Set<String> unsupportedEntityTypes = new HashSet<String>();

    public static void registerConfig() {
        RenderEntityTypeSupportConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        RenderEntityTypeSupportConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = RenderEntityTypeSupportConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = RenderEntityTypeSupportConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (Set<String> entityTypes : List.of(knownUnsupportedEntityTypes, knownSupportedEntityTypes, knownUnsupportedThirdPartyEntityTypes, knownSupportedThirdPartyEntityTypes)) {
            boolean defaultValue = entityTypes == knownSupportedEntityTypes || entityTypes == knownSupportedThirdPartyEntityTypes;
            for (String entityType : entityTypes) {
                if (RenderEntityTypeSupportConfig.parseConfigValue(properties, entityType, defaultValue)) {
                    RenderEntityTypeSupportConfig.addSupportedEntityType(entityType);
                    continue;
                }
                RenderEntityTypeSupportConfig.addUnsupportedEntityType(entityType);
            }
        }
        for (String entityType : properties.stringPropertyNames()) {
            if (RenderEntityTypeSupportConfig.isKnownEntityType(entityType)) continue;
            if (RenderEntityTypeSupportConfig.isInvalidEntityType(entityType)) {
                log.error("Remove invalid entity type {} from {}.", (Object)entityType, (Object)CONFIG_FILE_NAME);
                properties.remove(entityType);
                continue;
            }
            if (RenderEntityTypeSupportConfig.parseConfigValue(properties, entityType, false)) {
                RenderEntityTypeSupportConfig.addSupportedEntityType(entityType);
                continue;
            }
            RenderEntityTypeSupportConfig.addUnsupportedEntityType(entityType);
        }
        RenderEntityTypeSupportConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static void addUnsupportedEntityType(String entityType) {
        unsupportedEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
    }

    public static void addSupportedEntityType(String entityType) {
        supportedEntityTypes.add(entityType);
        unsupportedEntityTypes.remove(entityType);
    }

    public static boolean isSupportedEntityType(String entityType) {
        return supportedEntityTypes.contains(entityType);
    }

    public static boolean isUnsupportedEntityType(String entityType) {
        return unsupportedEntityTypes.contains(entityType);
    }

    private static boolean isKnownEntityType(String entityType) {
        return knownSupportedEntityTypes.contains(entityType) || knownUnsupportedEntityTypes.contains(entityType) || knownSupportedThirdPartyEntityTypes.contains(entityType) || knownUnsupportedThirdPartyEntityTypes.contains(entityType);
    }

    private static boolean isInvalidEntityType(String entityType) {
        return entityType == null || !entityType.contains(":");
    }
}

