/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SkeletonRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SkeletonNPC
extends SkeletonRaw
implements StandardEasyNPC<SkeletonRaw> {
    public static final String ID = "skeleton";
    public static final String ID_BOGGED = "skeleton_bogged";
    public static final String ID_STRAY = "skeleton_stray";
    public static final String ID_WITHER_SKELETON = "wither_skeleton";

    public SkeletonNPC(EntityType<? extends Skeleton> entityType, Level level) {
        this(entityType, level, SkeletonRaw.VariantType.SKELETON);
    }

    public SkeletonNPC(EntityType<? extends Skeleton> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        SkeletonRaw.VariantType soundVariant = SkeletonRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case BOGGED: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.BOGGED_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.BOGGED_DEATH);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.BOGGED_HURT);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.BOGGED_STEP);
                break;
            }
            case STRAY: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.STRAY_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.STRAY_DEATH);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.STRAY_HURT);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.STRAY_STEP);
                break;
            }
            case WITHER_SKELETON: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.WITHER_SKELETON_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.WITHER_SKELETON_DEATH);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.WITHER_SKELETON_HURT);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.WITHER_SKELETON_STEP);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.SKELETON_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.SKELETON_DEATH);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.SKELETON_HURT);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.SKELETON_STEP);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

