/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.armpose;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;

public class ModelArmPoseUtils {
    public static ModelArmPose getArmPoseForLeftArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, false);
    }

    public static ModelArmPose getArmPoseForRightArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, true);
    }

    private static ModelArmPose getArmPose(EasyNPC<?> easyNPC, boolean isRightArm) {
        boolean isRightHanded;
        if (easyNPC == null) {
            return ModelArmPose.DEFAULT;
        }
        class_1309 livingEntity = easyNPC.getLivingEntity();
        boolean bl = isRightHanded = livingEntity.method_6068() == class_1306.field_6183;
        if (livingEntity.method_6115()) {
            return ModelArmPoseUtils.getArmPoseWhileUsingItem(livingEntity, isRightArm, isRightHanded);
        }
        return ModelArmPoseUtils.getIdleArmPose(easyNPC, livingEntity, isRightArm, isRightHanded);
    }

    private static ModelArmPose getArmPoseWhileUsingItem(class_1309 livingEntity, boolean isRightArm, boolean isRightHanded) {
        boolean isUsingRightHand;
        ModelArmPose itemUseModelArmPose;
        class_1799 useItem = livingEntity.method_6030();
        if (useItem.method_7960()) {
            return ModelArmPose.DEFAULT;
        }
        switch (useItem.method_7976()) {
            case field_8953: {
                ModelArmPose modelArmPose = ModelArmPose.BOW_AND_ARROW;
                break;
            }
            case field_8947: {
                ModelArmPose modelArmPose = ModelArmPose.CROSSBOW_CHARGE;
                break;
            }
            case field_27079: {
                ModelArmPose modelArmPose = ModelArmPose.SPYGLASS;
                break;
            }
            case field_8951: {
                ModelArmPose modelArmPose = ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
                break;
            }
            default: {
                ModelArmPose modelArmPose = itemUseModelArmPose = ModelArmPose.DEFAULT;
            }
        }
        if (itemUseModelArmPose == ModelArmPose.BOW_AND_ARROW || itemUseModelArmPose == ModelArmPose.CROSSBOW_CHARGE) {
            return itemUseModelArmPose;
        }
        if (AttackHandler.isGunWeapon(useItem)) {
            return ModelArmPose.GUN_HOLD;
        }
        boolean isUsingMainHand = livingEntity.method_6058() == class_1268.field_5808;
        boolean bl = isUsingRightHand = isRightHanded && isUsingMainHand || !isRightHanded && !isUsingMainHand;
        if (isRightArm != isUsingRightHand) {
            return ModelArmPose.DEFAULT;
        }
        return itemUseModelArmPose;
    }

    private static ModelArmPose getIdleArmPose(EasyNPC<?> easyNPC, class_1309 livingEntity, boolean isRightArm, boolean isRightHanded) {
        class_1799 currentArmItem;
        class_1308 mob;
        if (!(easyNPC.getPathfinderMob().method_5968() != null || livingEntity instanceof class_1308 && (mob = (class_1308)livingEntity).method_6510())) {
            return ModelArmPose.DEFAULT;
        }
        class_1799 mainHandItem = livingEntity.method_6047();
        class_1799 offHandItem = livingEntity.method_6079();
        if (!mainHandItem.method_7960()) {
            if (mainHandItem.method_7909() instanceof class_1764) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
            if (AttackHandler.isBowWeapon(mainHandItem)) {
                return ModelArmPose.BOW_AND_ARROW;
            }
            if (AttackHandler.isGunWeapon(mainHandItem)) {
                return ModelArmPose.GUN_HOLD;
            }
        }
        if (!offHandItem.method_7960()) {
            if (offHandItem.method_7909() instanceof class_1764) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
            if (AttackHandler.isBowWeapon(offHandItem)) {
                return ModelArmPose.BOW_AND_ARROW;
            }
            if (AttackHandler.isGunWeapon(offHandItem)) {
                return ModelArmPose.GUN_HOLD;
            }
        }
        class_1799 itemInRightArm = isRightHanded ? mainHandItem : offHandItem;
        class_1799 itemInLeftArm = isRightHanded ? offHandItem : mainHandItem;
        class_1799 class_17992 = currentArmItem = isRightArm ? itemInRightArm : itemInLeftArm;
        if (!currentArmItem.method_7960() && AttackHandler.isMeleeWeapon(currentArmItem)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return ModelArmPose.DEFAULT;
    }
}

