/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.DegreeNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositionNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.ScaleNumberField;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class RangeSliderButton
extends class_339 {
    public static final class_2561 DECREASE_TEXT = TextComponent.getText("-");
    public static final class_2561 INCREASE_TEXT = TextComponent.getText("+");
    public static final class_2561 RESET_TEXT = TextComponent.getText("\u21ba");
    public static final class_2561 EDIT_TEXT = TextComponent.getText("\u270e");
    public static final class_2561 DONE_TEXT = TextComponent.getText("\u2714");
    private static final int DEFAULT_WIDTH = 170;
    private static final int DEFAULT_HEIGHT = 14;
    private static final int DECREASE_BUTTON_WIDTH = 12;
    private static final int INCREASE_BUTTON_WIDTH = 12;
    private static final int RESET_BUTTON_WIDTH = 12;
    private static final int EDIT_BUTTON_WIDTH = 12;
    private final SliderButton sliderButton;
    private final TextButton textButtonDecrease;
    private final TextButton textButtonIncrease;
    private final TextButton textButtonReset;
    private final TextButton textButtonEdit;
    private final TextButton textButtonDone;
    private final TextField textField;
    private final SliderButton.Type sliderType;
    private final boolean showButtons;

    public RangeSliderButton(int left, int top, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, 170, 14, value, minValue, maxValue, defaultValue, stepSize, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), sliderType, showButtons, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, minValue, maxValue, defaultValue, stepSize, SliderButton.Type.DOUBLE, true, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        super(left, top, width, height, (class_2561)TextComponent.getBlankText());
        class_327 font = class_310.method_1551().field_1772;
        this.sliderType = sliderType;
        this.showButtons = showButtons;
        this.sliderButton = new SliderButton(this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue, button -> this.updateSliderValue(button, onChange), this.sliderType);
        this.textField = switch (this.sliderType) {
            case SliderButton.Type.DEGREE -> new DegreeNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
            case SliderButton.Type.POSITION -> new PositionNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue);
            case SliderButton.Type.SCALE -> new ScaleNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue);
            default -> new PositiveNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
        };
        this.textField.method_1863(text -> {
            if (ValueUtils.isDoubleValue(text, minValue, maxValue)) {
                this.sliderButton.setDefaultValue(Double.parseDouble(text));
            }
        });
        this.textButtonDecrease = new TextButton(this.sliderButton.method_46426() - 12, top, 12, height, DECREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() - stepSize >= minValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() - stepSize);
                this.updateTextField();
            }
        });
        this.textButtonDecrease.field_22763 = showButtons;
        this.textButtonIncrease = new TextButton(this.sliderButton.method_46426() + this.sliderButton.method_25368(), top, 12, height, INCREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() + stepSize <= maxValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() + stepSize);
                this.updateTextField();
            }
        });
        this.textButtonIncrease.field_22763 = showButtons;
        this.textButtonReset = new TextButton(this.textButtonIncrease.method_46426() + this.textButtonIncrease.method_25368(), top, 12, height, RESET_TEXT, button -> {
            this.sliderButton.setDefaultValue(defaultValue);
            this.updateTextField();
        });
        this.textButtonReset.field_22763 = showButtons;
        this.textButtonEdit = new TextButton(this.textButtonReset.method_46426() + this.textButtonReset.method_25368(), top, 12, height, EDIT_TEXT, this::showTextField);
        this.textButtonEdit.field_22763 = showButtons;
        this.textButtonDone = new TextButton(this.textButtonReset.method_46426() + this.textButtonReset.method_25368(), top, 12, height, DONE_TEXT, this::showSliderButton);
        this.textButtonDone.field_22763 = showButtons;
    }

    public void reset() {
        this.sliderButton.reset();
        this.updateTextField();
    }

    public int getDefaultSliderWidth() {
        if (this.showButtons) {
            return this.field_22758 - 48;
        }
        return this.field_22758;
    }

    private void updateSliderValue(SliderButton sliderButton, SliderButton.OnChange onChange) {
        onChange.onChange(sliderButton);
    }

    private void updateTextField() {
        String sliderValue;
        switch (this.sliderType) {
            case DEGREE: {
                String string = String.format("%.1f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
                break;
            }
            default: {
                String string = sliderValue = String.format("%.2f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
            }
        }
        if (!this.textField.method_1882().equals(sliderValue)) {
            this.textField.method_1852(sliderValue);
        }
    }

    public void showTextField() {
        this.showTextField(null);
    }

    public void showSliderButton() {
        this.showSliderButton(null);
    }

    private void showTextField(class_4185 button) {
        this.updateTextField();
        this.sliderButton.field_22764 = false;
        this.sliderButton.method_25365(false);
        this.textButtonEdit.field_22764 = false;
        this.textButtonDone.field_22764 = true;
        this.textField.field_22764 = true;
    }

    private void showSliderButton(class_4185 button) {
        this.sliderButton.field_22764 = true;
        this.textButtonEdit.field_22764 = true;
        this.textButtonDone.field_22764 = false;
        this.textField.field_22764 = false;
        this.textField.method_25365(false);
    }

    public float getTargetValue() {
        return this.sliderButton.getTargetValue();
    }

    public void setTargetValue(float newValue) {
        this.sliderButton.setDefaultValue(newValue);
        this.updateTextField();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.sliderButton.field_22764) {
            this.sliderButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textField.field_22764) {
            this.textField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonDecrease.field_22763) {
            this.textButtonDecrease.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonIncrease.field_22763) {
            this.textButtonIncrease.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonReset.field_22763) {
            this.textButtonReset.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonEdit.field_22763 && this.textButtonEdit.field_22764) {
            this.textButtonEdit.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textButtonDone.field_22763 && this.textButtonDone.field_22764) {
            this.textButtonDone.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.sliderButton.field_22764 && this.sliderButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.textField.field_22764 && this.textField.method_25402(mouseX, mouseY, button)) {
            this.textField.method_25365(true);
            return true;
        }
        this.textButtonDecrease.method_25402(mouseX, mouseY, button);
        this.textButtonIncrease.method_25402(mouseX, mouseY, button);
        this.textButtonReset.method_25402(mouseX, mouseY, button);
        if (this.textButtonEdit.field_22764) {
            this.textButtonEdit.method_25402(mouseX, mouseY, button);
        } else if (this.textButtonDone.field_22764) {
            this.textButtonDone.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.textField.field_22764) {
            this.textField.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double x, double y, double scrollDeltaX, double scrollDeltaY) {
        if (this.sliderButton.field_22764) {
            return this.sliderButton.method_25401(x, y, scrollDeltaX, scrollDeltaY);
        }
        if (this.textField.field_22764) {
            return this.textField.method_25401(x, y, scrollDeltaX, scrollDeltaY);
        }
        return super.method_25401(x, y, scrollDeltaX, scrollDeltaY);
    }

    public void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.sliderButton.field_22764 && this.sliderButton.method_25405(mouseX, mouseY)) {
            this.sliderButton.triggerOnDrag(mouseX, mouseY, deltaX, deltaY);
        }
    }

    public boolean method_25400(char character, int keyCode) {
        if (this.sliderButton.field_22764) {
            return this.sliderButton.method_25400(character, keyCode);
        }
        if (this.textField.field_22764) {
            return this.textField.method_25400(character, keyCode);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int unused1, int unused2) {
        if (this.sliderButton.field_22764) {
            return this.sliderButton.method_25404(keyCode, unused1, unused2);
        }
        if (this.textField.field_22764) {
            return this.textField.method_25404(keyCode, unused1, unused2);
        }
        return false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            String usageKey = this.method_25370() ? "narration.slider.usage.focused" : "narration.slider.usage.hovered";
            narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)TextComponent.getTranslatedTextRaw(usageKey));
        }
    }
}

