/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class SpinButton<T>
extends CustomButton {
    private final TextButton previousButton;
    private final TextButton nextButton;
    private final TextButton textButton;
    private final List<T> values;
    private final OnChange onChange;
    private int currentIndex;

    public SpinButton(int x, int y, int width, int height, Set<T> values, T initialValue, OnChange onChange) {
        super(x, y, width, height);
        this.values = new ArrayList<T>(values);
        this.currentIndex = Math.max(0, this.values.indexOf(initialValue));
        this.onChange = onChange;
        int navWidth = 10;
        this.previousButton = new TextButton(x, y, navWidth, height, "<", this::previous);
        this.textButton = new TextButton(x + navWidth, y, width - 2 * navWidth, height, "", this::next);
        this.nextButton = new TextButton(x + width - navWidth, y, navWidth, height, ">", this::next);
        this.updateButtonStates();
    }

    private void previous(class_4185 button) {
        if (this.currentIndex > 0) {
            this.setIndex(this.currentIndex - 1);
        }
    }

    private void next(class_4185 button) {
        if (this.currentIndex < this.values.size() - 1) {
            this.setIndex(this.currentIndex + 1);
        } else if (button == this.textButton && !this.values.isEmpty()) {
            this.setIndex(0);
        }
    }

    private void setIndex(int index) {
        this.currentIndex = index;
        this.updateButtonStates();
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    private void updateButtonStates() {
        boolean hasValues = !this.values.isEmpty();
        this.previousButton.field_22763 = hasValues && this.currentIndex > 0;
        this.nextButton.field_22763 = hasValues && this.currentIndex < this.values.size() - 1;
        this.textButton.field_22763 = hasValues;
    }

    public T get() {
        return this.values.isEmpty() ? null : (T)this.values.get(this.currentIndex);
    }

    @Override
    public void renderButton(class_332 guiGraphics, int left, int top, float partialTicks) {
        this.previousButton.renderButton(guiGraphics, left, top, partialTicks);
        this.nextButton.renderButton(guiGraphics, left, top, partialTicks);
        this.textButton.renderButton(guiGraphics, left, top, partialTicks);
        T value = this.get();
        if (value != null) {
            this.textButton.method_25355((class_2561)TextComponent.getText(value.toString()));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.previousButton.method_25402(mouseX, mouseY, button) || this.nextButton.method_25402(mouseX, mouseY, button) || this.textButton.method_25402(mouseX, mouseY, button);
    }

    public static interface OnChange {
        public void onChange(SpinButton<?> var1);
    }
}

