/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.Set;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionUtils {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ConditionUtils() {
    }

    public static boolean evaluateCondition(ConditionDataEntry conditionDataEntry, class_3222 player) {
        if (conditionDataEntry == null || !conditionDataEntry.isValid() || player == null) {
            return false;
        }
        return switch (conditionDataEntry.conditionType()) {
            default -> throw new MatchException(null, null);
            case ConditionType.SCOREBOARD -> ConditionUtils.evaluateScoreboardCondition(conditionDataEntry, player);
            case ConditionType.NONE -> true;
        };
    }

    public static boolean evaluateConditions(Set<ConditionDataEntry> conditions, class_3222 player) {
        if (conditions == null || conditions.isEmpty() || player == null) {
            return true;
        }
        for (ConditionDataEntry condition : conditions) {
            if (ConditionUtils.evaluateCondition(condition, player)) continue;
            log.debug("Condition not met: {}", (Object)condition);
            return false;
        }
        return true;
    }

    public static boolean evaluateScoreboardCondition(ConditionDataEntry conditionDataEntry, class_3222 serverPlayer) {
        if (!conditionDataEntry.hasName() || serverPlayer == null) {
            return false;
        }
        try {
            class_269 scoreboard = serverPlayer.method_7327();
            class_266 objective = scoreboard.method_1170(conditionDataEntry.name());
            if (objective == null) {
                log.debug("Scoreboard objective '{}' not found for player {}", (Object)conditionDataEntry.name(), (Object)serverPlayer.method_5477().getString());
                return false;
            }
            class_9014 scoreAccess = scoreboard.method_1180((class_9015)serverPlayer, objective);
            int scoreValue = scoreAccess.method_55409();
            int targetValue = conditionDataEntry.value();
            boolean result = conditionDataEntry.operationType().evaluate(scoreValue, targetValue);
            log.debug("Scoreboard evaluation: {} {} {} = {} (actual: {})", (Object)conditionDataEntry.name(), (Object)conditionDataEntry.operationType().getSymbol(), (Object)targetValue, (Object)result, (Object)scoreValue);
            return result;
        }
        catch (Exception e) {
            log.error("Error evaluating scoreboard condition: {}", (Object)conditionDataEntry, (Object)e);
            return false;
        }
    }
}

