/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import de.markusbordihn.easynpc.data.type.ValueType;
import java.util.Locale;

public enum DisplayAttributeType {
    NONE(ValueType.STRING),
    VISIBLE(ValueType.BOOLEAN),
    VISIBLE_AT_DAY(ValueType.BOOLEAN),
    VISIBLE_AT_NIGHT(ValueType.BOOLEAN),
    VISIBLE_IN_CREATIVE(ValueType.BOOLEAN),
    VISIBLE_IN_SPECTATOR(ValueType.BOOLEAN),
    VISIBLE_IN_STANDARD(ValueType.BOOLEAN),
    VISIBLE_TO_OWNER(ValueType.BOOLEAN),
    VISIBLE_TO_TEAM(ValueType.BOOLEAN),
    LIGHT_LEVEL(ValueType.INTEGER),
    NAME_VISIBILITY(ValueType.STRING);

    private final ValueType valueType;

    private DisplayAttributeType(ValueType valueType) {
        this.valueType = valueType;
    }

    public static DisplayAttributeType get(String displayAttributeType) {
        if (displayAttributeType == null || displayAttributeType.isEmpty()) {
            return NONE;
        }
        try {
            return DisplayAttributeType.valueOf(displayAttributeType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public String getAttributeName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isValidValue(String value) {
        return this.valueType.isValidValue(value);
    }

    public Object parseValue(String value) {
        return this.valueType.parseValue(value);
    }
}

