/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3414;

public interface SoundDataCapable<E extends class_1314>
extends EasyNPC<E> {
    public static final String EASY_NPC_DATA_SOUND_DATA_TAG = "SoundData";

    public static void registerSyncedSoundData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Sound Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SOUND_DATA_SET, class_2945.method_12791(entityClass, EntityDataSerializersManager.SOUND_DATA_SET));
    }

    default public SoundDataSet getSoundDataSet() {
        return (SoundDataSet)this.getSynchedEntityData(SynchedDataIndex.SOUND_DATA_SET);
    }

    default public void setSoundDataSet(SoundDataSet soundDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.SOUND_DATA_SET, soundDataSet);
    }

    default public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        return soundDataSet;
    }

    default public void refreshSoundDataSet() {
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet == null || soundDataSet.isEmpty()) {
            this.clearSoundDataSet();
            this.setSoundDataSet(soundDataSet);
        }
    }

    default public void clearSoundDataSet() {
        this.setSoundDataSet(new SoundDataSet());
    }

    default public boolean hasDefaultSound(SoundType soundType) {
        return this.getSoundDataSet().hasSound(soundType);
    }

    default public SoundDataEntry getDefaultSound(SoundType soundType) {
        return this.getSoundDataSet().getSound(soundType);
    }

    default public class_3414 getDefaultSoundEvent(SoundType soundType) {
        if (!this.hasDefaultSound(soundType)) {
            return null;
        }
        return this.getDefaultSound(soundType).getSoundEvent();
    }

    default public void playDefaultTradeUpdatedSound(boolean yesSound) {
        if (yesSound) {
            this.playDefaultSound(SoundType.TRADE_YES);
        } else {
            this.playDefaultSound(SoundType.TRADE_NO);
        }
    }

    default public void playDefaultAmbientSound() {
        OwnerDataCapable ownerData = this.getEasyNPCOwnerData();
        if (ownerData != null && ownerData.hasNPCOwner()) {
            if (this.hasDefaultSound(SoundType.AMBIENT_TAMED) && EasyNPC.randomNumber.nextInt(4) == 0) {
                this.playDefaultSound(SoundType.AMBIENT_TAMED);
                return;
            }
            if (this.hasDefaultSound(SoundType.AMBIENT)) {
                this.playDefaultSound(SoundType.AMBIENT);
                return;
            }
        }
        if (this.hasDefaultSound(SoundType.AMBIENT_STRAY)) {
            this.playDefaultSound(SoundType.AMBIENT_STRAY);
        } else {
            this.playDefaultSound(SoundType.AMBIENT);
        }
    }

    default public void playDefaultHurtSound(class_1282 damageSource) {
        this.playDefaultSound(SoundType.HURT);
    }

    default public void playDefaultStepSound(class_2338 blockPos, class_2680 blockState) {
        this.playDefaultSound(SoundType.STEP);
    }

    default public void playDefaultSound(SoundType soundType) {
        class_3414 soundEvent;
        class_1937 level = this.getEntityLevel();
        class_1297 entity = this.getEntity();
        if (soundType == null || level == null || entity == null || entity.method_5701() || !this.hasDefaultSound(soundType)) {
            return;
        }
        SoundDataEntry soundDataEntry = this.getDefaultSound(soundType);
        if (soundDataEntry.isEnabled() && soundDataEntry.getVolume() > 0.0f && (soundEvent = soundDataEntry.getSoundEvent()) != null) {
            entity.method_5783(soundEvent, soundDataEntry.getVolume(), soundDataEntry.getPitch() + (EasyNPC.randomNumber.nextFloat() - EasyNPC.randomNumber.nextFloat()) * 0.3f);
        }
    }

    default public class_3414 getDefaultDeathSound() {
        return this.getDefaultSoundEvent(SoundType.DEATH);
    }

    default public void defineSynchedSoundData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SOUND_DATA_SET, new SoundDataSet());
    }

    default public void registerDefaultSoundData(Enum<?> variant) {
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet == null || soundDataSet.isEmpty()) {
            this.setSoundDataSet(this.getDefaultSoundDataSet(new SoundDataSet(), variant.name()));
        } else if (soundDataSet.isEmpty()) {
            this.setSoundDataSet(this.getDefaultSoundDataSet(soundDataSet, variant.name()));
        }
    }

    default public void addAdditionalSoundData(class_2487 compoundTag) {
        class_2487 soundDataTag = new class_2487();
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet != null && !soundDataSet.isEmpty()) {
            soundDataSet.save(soundDataTag);
        } else {
            VariantDataCapable variantData = this.getEasyNPCVariantData();
            SoundDataSet defaultSoundDataSet = this.getDefaultSoundDataSet(new SoundDataSet(), variantData != null ? variantData.getSkinVariantType().name() : "");
            defaultSoundDataSet.save(soundDataTag);
        }
        compoundTag.method_10566(EASY_NPC_DATA_SOUND_DATA_TAG, (class_2520)soundDataTag);
    }

    default public void readAdditionalSoundData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_SOUND_DATA_TAG)) {
            return;
        }
        class_2487 soundDataTag = compoundTag.method_68568(EASY_NPC_DATA_SOUND_DATA_TAG);
        if (soundDataTag.method_10545("SoundDataSet")) {
            SoundDataSet soundDataSet = new SoundDataSet(soundDataTag);
            this.setSoundDataSet(soundDataSet);
        }
    }
}

