/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.skin.variant.HumanoidSkinVariant;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public interface VariantDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TYPE_TAG = "VariantType";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Variant Type Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT_TYPE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13326));
    }

    default public Enum<?> getDefaultSkinVariantType() {
        return HumanoidSkinVariant.STEVE;
    }

    default public Enum<?> getSkinVariantType() {
        return this.getSkinVariantType((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT_TYPE));
    }

    default public void setSkinVariantType(Enum<?> variant) {
        if (this.getSkinVariantType() != variant) {
            this.setSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, variant != null ? variant.name() : "");
            this.handleSkinVariantTypeChange(variant);
        }
    }

    default public void setSkinVariantType(String name) {
        Enum<?> variantType = this.getSkinVariantType(name);
        if (variantType != null) {
            this.setSkinVariantType(variantType);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public void handleSkinVariantTypeChange(Enum<?> variant) {
    }

    default public Enum<?> getSkinVariantType(String name) {
        return HumanoidSkinVariant.valueOf(name);
    }

    default public Enum<?>[] getSkinVariantTypes() {
        return HumanoidSkinVariant.values();
    }

    default public Stream<String> getSkinVariantTypeNames() {
        return Stream.of(this.getSkinVariantTypes()).map(Enum::name);
    }

    default public class_2561 getSkinVariantTypeName() {
        Enum<?> variant = this.getSkinVariantType();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEntityTypeName();
    }

    default public boolean hasVariantTypeCrossedArms() {
        return this.hasVariantTypeCrossedArms(this.getSkinVariantType());
    }

    default public boolean hasVariantTypeCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantTypeSaddled() {
        return this.hasVariantTypeSaddled(this.getSkinVariantType());
    }

    default public boolean hasVariantTypeSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public class_6880<class_3852> getVillagerProfession(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (class_3852 profession : class_7923.field_41195) {
            if (!name.endsWith(profession.comp_818().getString().toLowerCase(Locale.ROOT))) continue;
            return class_7923.field_41195.method_47983((Object)profession);
        }
        return null;
    }

    default public class_6880<class_3854> getVillagerType(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (class_3854 villagerType : class_7923.field_41194) {
            if (!name.startsWith(villagerType.toString().toLowerCase(Locale.ROOT))) continue;
            return class_7923.field_41194.method_47983((Object)villagerType);
        }
        return null;
    }

    default public void defineSynchedVariantData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.VARIANT_TYPE, this.getDefaultSkinVariantType().name());
    }

    default public void addAdditionalVariantData(class_2487 compoundTag) {
        if (this.getSkinVariantType() != null) {
            compoundTag.method_10582(EASY_NPC_DATA_VARIANT_TYPE_TAG, this.getSkinVariantType().name());
        }
    }

    default public void readAdditionalVariantData(class_2487 compoundTag) {
        String variantType;
        if (compoundTag.method_10545(EASY_NPC_DATA_VARIANT_TYPE_TAG) && !(variantType = compoundTag.method_10558(EASY_NPC_DATA_VARIANT_TYPE_TAG).orElse("")).isEmpty()) {
            this.setSkinVariantType(this.getSkinVariantType(variantType));
        }
    }
}

