/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionGroup;
import de.markusbordihn.easynpc.data.action.ActionManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.CommandActionExecutor;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.DialogActionExecutor;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.ScoreboardActionExecutor;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public interface ActionHandler<E extends class_1314>
extends EasyNPC<E> {
    default public List<? extends class_1657> getPlayersInRange(Double range) {
        class_1297 entity = this.getEntity();
        return this.getEntityLevel().method_18456().stream().filter(class_1301.field_6155).filter(targetPlayers -> entity.method_24516((class_1297)targetPlayers, range.doubleValue())).toList();
    }

    default public void checkTradingActions() {
        this.getProfiler().method_15396("npcCheckTradingActions");
        TradingDataCapable tradingData = this.getEasyNPCTradingData();
        TickerDataCapable tickerData = this.getEasyNPCTickerData();
        if (tradingData == null || tickerData == null) {
            return;
        }
        this.getProfiler().method_15407();
    }

    default public void checkDistanceActions() {
        class_3222 serverPlayer;
        ActionDataEntry actionDataEntry;
        List<class_1657> listOfPlayers;
        this.getProfiler().method_15396("npcCheckDistanceActions");
        class_1308 mob = this.getMob();
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null || mob == null || mob.method_29504()) {
            return;
        }
        boolean skipPlayerDistanceCheck = false;
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_NEAR)) {
            listOfPlayers = this.getPlayersInRange(16.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_NEAR);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_NEAR);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_CLOSE)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(8.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_CLOSE);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(4.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_VERY_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_TOUCH)) {
            List<class_1657> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(1.25);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_TOUCH);
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_TOUCH);
                for (class_1657 player : listOfPlayers) {
                    if (!(player instanceof class_3222) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer = (class_3222)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer);
                }
            }
        }
        this.getProfiler().method_15407();
    }

    default public void interactWithBlock(class_2338 blockPos) {
        class_1309 livingEntity = this.getLivingEntity();
        if (livingEntity != null && !this.isClientSideInstance()) {
            this.lookAtBlock(blockPos);
            livingEntity.method_6104(class_1268.field_5808);
            if (!livingEntity.method_6047().method_7960()) {
                this.getEntityServerLevel().method_8320(blockPos).method_55780(livingEntity.method_6047(), (class_1937)this.getEntityServerLevel(), (class_1657)this.getFakePlayer(this.getEntityServerLevel(), blockPos), class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)blockPos), class_2350.field_11033, blockPos, false));
            } else {
                this.getEntityServerLevel().method_8320(blockPos).method_55781((class_1937)this.getEntityServerLevel(), (class_1657)this.getFakePlayer(this.getEntityServerLevel(), blockPos), new class_3965(class_243.method_24953((class_2382)blockPos), class_2350.field_11033, blockPos, false));
            }
            livingEntity.method_6047().method_7913((class_1937)this.getEntityServerLevel(), (class_1657)this.getFakePlayer(this.getEntityServerLevel(), blockPos), class_1268.field_5808);
        }
    }

    default public void lookAtBlock(class_2338 target) {
        class_1297 entity = this.getEntity();
        class_243 vec3d = entity.method_19538();
        class_243 targetVec = class_243.method_24953((class_2382)target);
        class_243 delta = targetVec.method_1020(vec3d);
        double horizontalDistance = delta.method_37267();
        entity.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)delta.field_1351, (double)horizontalDistance) * 57.29577951308232)))));
        entity.method_5636(class_3532.method_15393((float)((float)(class_3532.method_15349((double)delta.field_1350, (double)delta.field_1352) * 57.29577951308232) - 90.0f)));
        entity.method_5847(entity.method_5791());
    }

    default public void executeActions(ActionDataSet actionDataSet, class_3222 serverPlayer) {
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            return;
        }
        ActionDataEntry closeDialogAction = null;
        boolean hasScreenAction = false;
        for (ActionDataEntry actionDataEntry : actionDataSet.getEntries()) {
            ActionDataType actionType = actionDataEntry.actionDataType();
            if (actionType == ActionDataType.CLOSE_DIALOG) {
                if (closeDialogAction == null) {
                    closeDialogAction = actionDataEntry;
                    continue;
                }
                log.warn("Multiple close dialog actions found in action data set {}!", (Object)actionDataSet);
                continue;
            }
            if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG || actionType == ActionDataType.OPEN_NAMED_DIALOG || actionType == ActionDataType.OPEN_TRADING_SCREEN) {
                if (hasScreenAction) {
                    log.debug("Ignoring {}. Multiple screen actions found in action data set {}! Only the first valid will be executed.", (Object)actionType, (Object)actionDataSet);
                    continue;
                }
                if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG && !this.getEasyNPCDialogData().hasDialog() || actionType == ActionDataType.OPEN_NAMED_DIALOG && !this.getEasyNPCDialogData().hasDialog(actionDataEntry.command()) || actionType == ActionDataType.OPEN_TRADING_SCREEN && !this.getEasyNPCTradingData().hasTradingData()) {
                    log.debug("Ignoring {} action because no data is available.", (Object)actionType);
                    continue;
                }
                hasScreenAction = true;
            }
            this.executeAction(actionDataEntry, serverPlayer);
        }
        if (closeDialogAction != null) {
            this.executeAction(closeDialogAction, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        switch (actionDataEntry.actionDataType()) {
            case NONE: {
                break;
            }
            case COMMAND: {
                if (actionDataEntry.executeAsUser()) {
                    CommandActionExecutor.executeAsPlayer(actionDataEntry, serverPlayer, this.getLivingEntity(), this.getEasyNPCActionEventData());
                    break;
                }
                CommandActionExecutor.executeAsEntity(actionDataEntry, serverPlayer, this.getEntity(), this.getLivingEntity(), this.getEasyNPCActionEventData());
                break;
            }
            case CLOSE_DIALOG: {
                serverPlayer.method_7346();
                break;
            }
            case INTERACT_BLOCK: {
                class_2338 blockPos = actionDataEntry.blockPos();
                if (ActionValidator.validateBlockPos(blockPos)) {
                    this.interactWithBlock(blockPos);
                    break;
                }
                log.error("No block position found for action {}", (Object)actionDataEntry);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                DialogActionExecutor.openDefaultDialog(actionDataEntry, serverPlayer, this.getEasyNPCDialogData());
                break;
            }
            case OPEN_NAMED_DIALOG: {
                DialogActionExecutor.openNamedDialog(actionDataEntry, serverPlayer, this.getEasyNPCDialogData());
                break;
            }
            case OPEN_TRADING_SCREEN: {
                TradingDataCapable tradingData = this.getEasyNPCTradingData();
                if (tradingData != null) {
                    tradingData.openTradingScreen(serverPlayer);
                    break;
                }
                log.warn("Cannot execute OPEN_TRADING_SCREEN action for player {}: No trading data found in action {}", (Object)serverPlayer.method_5477().getString(), (Object)actionDataEntry);
                break;
            }
            case SCOREBOARD: {
                ScoreboardActionExecutor.execute(actionDataEntry, serverPlayer);
                break;
            }
            default: {
                log.warn("Unknown action type {} for action {}", (Object)actionDataEntry.actionDataType(), (Object)actionDataEntry);
            }
        }
    }
}

