/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardOperation;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_3222;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScoreboardActionExecutor {
    protected static final Logger log = LogManager.getLogger(ScoreboardActionExecutor.class);

    private ScoreboardActionExecutor() {
    }

    public static void execute(ActionDataEntry actionDataEntry, class_3222 serverPlayer) {
        class_269 scoreboard;
        class_266 objective;
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            log.warn("Failed to execute scoreboard action for player {}: Invalid action data", (Object)serverPlayer.method_5477().getString());
            return;
        }
        String command = actionDataEntry.command();
        if (!ActionValidator.validateCommand(command)) {
            log.warn("Failed to execute scoreboard action for player {}: No command found in action {}", (Object)serverPlayer.method_5477().getString(), (Object)actionDataEntry);
            return;
        }
        String[] parts = command.split(":", 3);
        if (parts.length < 2) {
            log.warn("Failed to execute scoreboard action for player {}: Invalid command format '{}'. Expected format: 'operation:scoreboardName:value'", (Object)serverPlayer.method_5477().getString(), (Object)command);
            return;
        }
        ScoreboardOperation operation = ScoreboardOperation.fromCommandName(parts[0]);
        String scoreboardName = parts[1];
        if (scoreboardName == null || scoreboardName.trim().isEmpty()) {
            log.warn("Failed to execute scoreboard action for player {}: Scoreboard name is empty", (Object)serverPlayer.method_5477().getString());
            return;
        }
        int value = 1;
        if (parts.length > 2) {
            try {
                value = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to execute scoreboard action for player {}: Invalid value '{}'. Value must be an integer", (Object)serverPlayer.method_5477().getString(), (Object)parts[2]);
                return;
            }
        }
        if ((objective = (scoreboard = serverPlayer.method_7327()).method_1170(scoreboardName)) == null) {
            objective = scoreboard.method_1168(scoreboardName, class_274.field_1468, (class_2561)class_2561.method_43470((String)scoreboardName), class_274.class_275.field_1472, false, null);
            if (actionDataEntry.enableDebug()) {
                log.debug("Created new scoreboard objective: {}", (Object)scoreboardName);
            }
        }
        class_9014 scoreAccess = scoreboard.method_1180((class_9015)serverPlayer, objective);
        switch (operation) {
            case INCREASE: {
                scoreAccess.method_55414(value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Increased scoreboard {} with {} for player {} by {}", (Object)scoreboardName, (Object)scoreAccess.method_55409(), (Object)serverPlayer.method_5477().getString(), (Object)value);
                break;
            }
            case DECREASE: {
                scoreAccess.method_55414(-value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Decreased scoreboard {} with {} for player {} by {}", (Object)scoreboardName, (Object)scoreAccess.method_55409(), (Object)serverPlayer.method_5477().getString(), (Object)value);
                break;
            }
            case SET: {
                scoreAccess.method_55410(value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Set scoreboard {} with {} for player {} to {}", (Object)scoreboardName, (Object)scoreAccess.method_55409(), (Object)serverPlayer.method_5477().getString(), (Object)value);
            }
        }
    }
}

