/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_2561;

public class TextFormattingCodes {
    private static final Map<String, String> TEXT_COLOR_CODES = (Map)class_156.method_654(new HashMap(), map -> {
        map.put("black", COLOR_DEFAULT_CODE);
        map.put("dark_blue", "\u00a71");
        map.put("dark_green", "\u00a72");
        map.put("dark_aqua", "\u00a73");
        map.put("dark_red", "\u00a74");
        map.put("dark_purple", "\u00a75");
        map.put("gold", "\u00a76");
        map.put("gray", "\u00a77");
        map.put("dark_gray", "\u00a78");
        map.put("blue", "\u00a79");
        map.put("green", "\u00a7a");
        map.put("aqua", "\u00a7b");
        map.put("red", "\u00a7c");
        map.put("light_purple", "\u00a7d");
        map.put("yellow", "\u00a7e");
        map.put("white", "\u00a7f");
    });
    private static final Map<String, String> TEXT_FORMATTING_CODES = (Map)class_156.method_654(new HashMap(), map -> {
        map.put("obfuscated", "\u00a7k");
        map.put("bold", "\u00a7l");
        map.put("strikethrough", "\u00a7m");
        map.put("underline", "\u00a7n");
        map.put("italic", "\u00a7o");
        map.put("reset", FORMATTING_RESET_CODE);
        map.put("b", "\u00a7l");
        map.put("i", "\u00a7o");
        map.put("u", "\u00a7n");
        map.put("s", "\u00a7m");
    });
    private static final Set<String> textLinebreakCodes = new HashSet<String>(List.of("<br>", "\\n"));
    private static final String FORMATTING_RESET_CODE = "\u00a7r";
    private static final String COLOR_DEFAULT_CODE = "\u00a70";
    private static final String LINE_BREAK = "\n";

    private TextFormattingCodes() {
    }

    public static boolean hasTextFormattingCodes(String text) {
        return text != null && text.contains("<") && text.contains(">");
    }

    public static String parseTextFormattingCodes(String text) {
        if (!TextFormattingCodes.hasTextFormattingCodes(text)) {
            return text;
        }
        for (Map.Entry<String, String> entry : TEXT_COLOR_CODES.entrySet()) {
            text = text.replace("<" + entry.getKey() + ">", entry.getValue());
            text = text.replace("</" + entry.getKey() + ">", COLOR_DEFAULT_CODE);
        }
        for (Map.Entry<String, String> entry : TEXT_FORMATTING_CODES.entrySet()) {
            text = text.replace("<" + entry.getKey() + ">", entry.getValue());
            text = text.replace("</" + entry.getKey() + ">", FORMATTING_RESET_CODE);
        }
        return text;
    }

    public static boolean hasTextLinebreakCodes(class_2561 component) {
        return component != null && TextFormattingCodes.hasTextLinebreakCodes(component.getString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasTextLinebreakCodes(String text) {
        if (text == null) return false;
        if (text.isEmpty()) return false;
        if (!textLinebreakCodes.stream().anyMatch(text::contains)) return false;
        return true;
    }

    public static class_2561 parseTextLineBreaks(class_2561 component) {
        return component != null ? TextComponent.getText(TextFormattingCodes.parseTextLineBreaks(component.getString())) : null;
    }

    public static String parseTextLineBreaks(String text) {
        if (!TextFormattingCodes.hasTextLinebreakCodes(text)) {
            return text;
        }
        for (String lineBreakCode : textLinebreakCodes) {
            text = text.replace(lineBreakCode, LINE_BREAK);
        }
        return text;
    }
}

