/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.entity.standard.PlayerRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.HumanoidSlimNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;

public class PlayerSlimRenderer
extends PlayerRenderer {
    protected static final Map<HumanoidSlimNPC.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.m_137469_(new EnumMap(HumanoidSlimNPC.VariantType.class), map -> {
        map.put(HumanoidSlimNPC.VariantType.ALEX, new ResourceLocation("minecraft", "textures/entity/player/slim/alex.png"));
        map.put(HumanoidSlimNPC.VariantType.ARI, new ResourceLocation("minecraft", "textures/entity/player/slim/ari.png"));
        map.put(HumanoidSlimNPC.VariantType.EFE, new ResourceLocation("minecraft", "textures/entity/player/slim/efe.png"));
        map.put(HumanoidSlimNPC.VariantType.KAI, new ResourceLocation("minecraft", "textures/entity/player/slim/kai.png"));
        map.put(HumanoidSlimNPC.VariantType.MAKENA, new ResourceLocation("minecraft", "textures/entity/player/slim/makena.png"));
        map.put(HumanoidSlimNPC.VariantType.NOOR, new ResourceLocation("minecraft", "textures/entity/player/slim/noor.png"));
        map.put(HumanoidSlimNPC.VariantType.STEVE, new ResourceLocation("minecraft", "textures/entity/player/slim/steve.png"));
        map.put(HumanoidSlimNPC.VariantType.SUNNY, new ResourceLocation("minecraft", "textures/entity/player/slim/sunny.png"));
        map.put(HumanoidSlimNPC.VariantType.ZURI, new ResourceLocation("minecraft", "textures/entity/player/slim/zuri.png"));
        map.put(HumanoidSlimNPC.VariantType.KAWORRU, new ResourceLocation("easy_npc", "textures/entity/humanoid_slim/kaworru.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)HumanoidSlimNPC.VariantType.ALEX);

    public PlayerSlimRenderer(EntityRendererProvider.Context context) {
        super(context, true);
    }

    public ResourceLocation getTextureLocation(PathfinderMob entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityPlayerTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum variantType) {
        return TEXTURE_BY_VARIANT_TYPE != null ? TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }
}

