/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.objective;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.BowAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CrossbowAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomLookAtPlayerGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomMeleeAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomOwnerHurtByTargetGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.FollowLivingEntityGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.GunAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.MoveBackToHomeGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.RandomStrollAroundGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.RandomStrollAroundHomeGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ResetLookAtPlayerGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ZombieAttackGoal;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectiveUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ObjectiveUtils() {
    }

    public static Goal createObjectiveGoal(ObjectiveDataEntry objectiveDataEntry, EasyNPC<?> easyNPC) {
        Entity targetOwner = objectiveDataEntry.getTargetOwner(easyNPC);
        PathfinderMob pathfinderMob = easyNPC.getPathfinderMob();
        switch (objectiveDataEntry.getType()) {
            case FOLLOW_PLAYER: {
                ServerPlayer targetServerPlayer = objectiveDataEntry.getTargetPlayer();
                if (targetServerPlayer != null && !targetServerPlayer.m_213877_()) {
                    return new FollowLivingEntityGoal(easyNPC, (LivingEntity)targetServerPlayer, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find valid player {} for {}!", (Object)objectiveDataEntry.getTargetPlayer(), (Object)objectiveDataEntry);
                break;
            }
            case FOLLOW_OWNER: {
                LivingEntity livingEntity;
                if (targetOwner instanceof LivingEntity && !(livingEntity = (LivingEntity)targetOwner).m_213877_()) {
                    return new FollowLivingEntityGoal(easyNPC, livingEntity, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find valid owner {} for {} with {}!", (Object)targetOwner, (Object)easyNPC.getEntity(), (Object)objectiveDataEntry);
                break;
            }
            case FOLLOW_ENTITY_BY_UUID: {
                LivingEntity targetEntityMob = objectiveDataEntry.getTargetEntity(easyNPC);
                if (targetEntityMob != null && !targetEntityMob.m_213877_()) {
                    return new FollowLivingEntityGoal(easyNPC, targetEntityMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find living entity {} for {}!", (Object)objectiveDataEntry.getTargetEntityUUID(), (Object)objectiveDataEntry);
                break;
            }
            case RANDOM_STROLL: {
                return new RandomStrollAroundGoal(easyNPC, objectiveDataEntry.getSpeedModifier());
            }
            case WATER_AVOIDING_RANDOM_STROLL: {
                return new WaterAvoidingRandomStrollGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case MOVE_THROUGH_VILLAGE: {
                return new MoveThroughVillageGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getOnlyAtNight(), objectiveDataEntry.getDistanceToPoi(), objectiveDataEntry.getCanDealWithDoors());
            }
            case MOVE_BACK_TO_HOME: {
                return new MoveBackToHomeGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance());
            }
            case MOVE_BACK_TO_VILLAGE: {
                return new MoveBackToVillageGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier(), false);
            }
            case RANDOM_STROLL_AROUND_HOME: {
                return new RandomStrollAroundHomeGoal(easyNPC, objectiveDataEntry.getSpeedModifier());
            }
            case RANDOM_STROLL_IN_VILLAGE: {
                return new GolemRandomStrollInVillageGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case CROSSBOW_ATTACK: {
                return new CrossbowAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackRadius());
            }
            case BOW_ATTACK: {
                return new BowAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackInterval(), objectiveDataEntry.getAttackRadius());
            }
            case MELEE_ATTACK: {
                return new CustomMeleeAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.isMustSeeTarget());
            }
            case ZOMBIE_ATTACK: {
                return new ZombieAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.isMustSeeTarget());
            }
            case GUN_ATTACK: {
                return new GunAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackInterval(), objectiveDataEntry.getAttackRadius());
            }
            case RANDOM_SWIMMING: {
                return new RandomSwimmingGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getInterval());
            }
            case FLOAT: {
                return new FloatGoal((Mob)pathfinderMob);
            }
            case OPEN_DOOR: {
                return new OpenDoorGoal((Mob)pathfinderMob, false);
            }
            case CLOSE_DOOR: {
                return new OpenDoorGoal((Mob)pathfinderMob, true);
            }
            case LOOK_AT_RESET: {
                return new ResetLookAtPlayerGoal(easyNPC);
            }
            case LOOK_AT_PLAYER: {
                return new CustomLookAtPlayerGoal(easyNPC, Player.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_AT_MOB: {
                return new CustomLookAtPlayerGoal(easyNPC, Mob.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_AT_ANIMAL: {
                return new CustomLookAtPlayerGoal(easyNPC, Animal.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_RANDOM_AROUND: {
                return new RandomLookAroundGoal((Mob)pathfinderMob);
            }
            case PANIC: {
                return new PanicGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case AVOID_SUN: {
                return new RestrictSunGoal(pathfinderMob);
            }
            case FLEE_SUN: {
                return new FleeSunGoal(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static Goal createObjectiveTarget(ObjectiveDataEntry objectiveDataEntry, EasyNPC<?> easyNPC) {
        PathfinderMob pathfinderMob = easyNPC.getPathfinderMob();
        return switch (objectiveDataEntry.getType()) {
            case ObjectiveType.ATTACK_ANIMAL -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Animal.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_PLAYER -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Player.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_PLAYER_WITHOUT_OWNER -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Player.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), entity -> easyNPC.getEasyNPCOwnerData() != null && entity != easyNPC.getEasyNPCOwnerData().m_269323_());
            case ObjectiveType.ATTACK_MONSTER -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Monster.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_MOB_WITHOUT_CREEPER -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Mob.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), entity -> entity instanceof Enemy && !(entity instanceof Creeper));
            case ObjectiveType.ATTACK_MOB -> new NearestAttackableTargetGoal((Mob)pathfinderMob, Mob.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), Enemy.class::isInstance);
            case ObjectiveType.ATTACK_VILLAGER -> new NearestAttackableTargetGoal((Mob)pathfinderMob, AbstractVillager.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.OWNER_HURT_BY_TARGET -> new CustomOwnerHurtByTargetGoal(easyNPC);
            case ObjectiveType.HURT_BY_TARGET -> {
                HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal(pathfinderMob, new Class[0]);
                hurtByTargetGoal.m_26044_(new Class[0]);
                yield hurtByTargetGoal;
            }
            default -> null;
        };
    }
}

