/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import java.util.stream.Stream;

public enum SoundType {
    AMBIENT,
    AMBIENT_STRAY,
    AMBIENT_TAMED,
    CAST_SPELL,
    CELEBRATE,
    DAMAGE,
    DEATH,
    DEFAULT,
    DRINKING,
    EAT,
    FALL_DAMAGE_BIG,
    FALL_DAMAGE_SMALL,
    HURT,
    STEP,
    SWIM,
    TRADE,
    TRADE_YES,
    TRADE_NO;


    public static SoundType get(String soundType) {
        if (soundType == null || soundType.isEmpty()) {
            return DEFAULT;
        }
        try {
            return SoundType.valueOf(soundType);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT;
        }
    }

    public static Stream<String> getSoundTypeNames() {
        return Stream.of(SoundType.values()).map(Enum::name);
    }
}

