/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import com.google.common.collect.ImmutableList;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.VillagerRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VillagerNPC
extends VillagerRaw
implements StandardEasyNPC<VillagerRaw> {
    public static final String ID = "villager";
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26325_, (Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_148205_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26368_, MemoryModuleType.f_26377_, MemoryModuleType.f_26361_, MemoryModuleType.f_26370_});
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26818_, (Object)SensorType.f_26814_, (Object)SensorType.f_26813_, (Object)SensorType.f_26810_, (Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26817_, (Object)SensorType.f_26816_, (Object)SensorType.f_26815_);

    public VillagerNPC(EntityType<? extends Villager> entityType, Level level) {
        this(entityType, level, VillagerRaw.VariantType.DEFAULT_NITWIT);
    }

    public VillagerNPC(EntityType<? extends Villager> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.m_20331_(true);
    }

    public static AttributeSupplier.Builder m_35503_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22287_, 0.0);
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public Component m_7755_() {
        Component component = this.m_7770_();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getVariantTypeName();
        return TextComponent.getText(variantName.getString() + " (" + professionName.getString() + ")");
    }

    public boolean m_35392_(long gameTime) {
        return false;
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12503_);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12505_);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12506_);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    protected void m_8099_() {
    }

    protected Brain.Provider<Villager> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.m_7023_(vec3);
        } else {
            this.m_267651_(this instanceof FlyingAnimal);
        }
    }
}

