/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "preset";
    private static final ConcurrentHashMap<ResourceLocation, Path> presetResourceLocationMap = new ConcurrentHashMap();

    private WorldPresetDataFiles() {
    }

    public static void registerWorldPresetData() {
        log.info("{} world preset data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        WorldPresetDataFiles.refreshPresetResourceLocations();
    }

    public static Path getPresetDataFolder() {
        File worldDataFolder = new File(Constants.WORLD_DIR.toFile(), "easy_npc");
        Path path = worldDataFolder.toPath().resolve(DATA_FOLDER_NAME);
        if (!path.toFile().exists() && !path.toFile().mkdirs()) {
            log.error("Could not create preset data folder {}!", (Object)path);
        }
        return path;
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
        String skinModelName = skinModel.name();
        if (!skinModelName.isEmpty()) {
            Path path = presetDataFolder.resolve(skinModelName.toLowerCase(Locale.ROOT));
            if (!path.toFile().exists() && !path.toFile().mkdirs()) {
                log.error("Could not create preset model folder {}!", (Object)path);
            }
            return path;
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = WorldPresetDataFiles.getPresetDataFolder(skinModel);
        if (presetModelFolder != null && fileName != null && !fileName.isEmpty()) {
            return presetModelFolder.resolve(DataFileHandler.getPresetFileName(fileName)).toFile();
        }
        return null;
    }

    public static Stream<ResourceLocation> getPresetResourceLocations() {
        return presetResourceLocationMap.keySet().stream();
    }

    public static Set<ResourceLocation> getPresetResourceLocationSet() {
        return presetResourceLocationMap.keySet();
    }

    public static void refreshPresetResourceLocations() {
        Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
        presetResourceLocationMap.clear();
        try (Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);){
            filesStream.filter(DataFileHandler::isPresetFile).forEach(path -> {
                ResourceLocation resourceLocation = new ResourceLocation("easy_npc", "preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/").toLowerCase(Locale.ROOT));
                presetResourceLocationMap.put(resourceLocation, (Path)path);
            });
        }
        catch (IOException exception) {
            log.error("Could not read world preset data folder {}:", (Object)presetDataFolder, (Object)exception);
        }
    }

    public static Path getPresetsResourceLocationPath(ResourceLocation resourceLocation) {
        Path path = presetResourceLocationMap.get(resourceLocation);
        if (path == null) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            path = presetResourceLocationMap.get(resourceLocation);
        }
        return path;
    }
}

