/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.trading.Merchant;

public class TradingCommand
extends Command {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"trading").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"open").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            return TradingCommand.open((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), serverPlayer);
        })).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TradingCommand.open((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> TradingCommand.reset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))));
    }

    private static int reset(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            return TradingCommand.sendFailureMessageNoTradingData(context, easyNPC);
        }
        tradingData.resetTradingOffers();
        return TradingCommand.sendSuccessMessage(context, "Trading offers for " + String.valueOf(easyNPC) + " were reset to default values.");
    }

    private static int open(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        if (easyNPC == null || serverPlayer == null) {
            return 0;
        }
        Merchant merchant = easyNPC.getMerchant();
        if (merchant == null) {
            return TradingCommand.sendFailureMessageNoMerchant(context, easyNPC);
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            return TradingCommand.sendFailureMessageNoTradingData(context, easyNPC);
        }
        tradingData.openTradingScreen(serverPlayer);
        return TradingCommand.sendSuccessMessage(context, "Opened trading screen for " + String.valueOf(serverPlayer) + " with merchant " + String.valueOf(easyNPC) + " !");
    }
}

