/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemUtils {
    private static final ResourceLocation EASY_NPC_WAND_RESOURCE_LOCATION = new ResourceLocation("easy_npc", "easy_npc_wand");
    private static final ResourceLocation MOVE_EASY_NPC_RESOURCE_LOCATION = new ResourceLocation("easy_npc", "move_easy_npc");
    private static Item cachedEasyNpcWandItem = null;
    private static Item cachedMoveEasyNpcItem = null;

    private ItemUtils() {
    }

    public static boolean isPlayerHoldingEasyNPCWand(Player player) {
        if (player == null) {
            return false;
        }
        Item easyNpcWandItem = ItemUtils.getEasyNPCWandItem();
        if (easyNpcWandItem == null || easyNpcWandItem == Items.f_41852_) {
            return false;
        }
        return ItemUtils.isPlayerHoldingItem(player, easyNpcWandItem);
    }

    public static boolean isPlayerHoldingItem(Player player, Item targetItem) {
        if (player == null || targetItem == null) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (ItemUtils.isItemStackOfType(mainHandItem, targetItem)) {
            return true;
        }
        ItemStack offHandItem = player.m_21206_();
        return ItemUtils.isItemStackOfType(offHandItem, targetItem);
    }

    private static boolean isItemStackOfType(ItemStack itemStack, Item targetItem) {
        return !itemStack.m_41619_() && itemStack.m_41720_() == targetItem;
    }

    public static Item getEasyNPCWandItem() {
        if (cachedEasyNpcWandItem == null) {
            cachedEasyNpcWandItem = (Item)BuiltInRegistries.f_257033_.m_7745_(EASY_NPC_WAND_RESOURCE_LOCATION);
        }
        return cachedEasyNpcWandItem;
    }

    public static Item getMoveEasyNPCItem() {
        if (cachedMoveEasyNpcItem == null) {
            cachedMoveEasyNpcItem = (Item)BuiltInRegistries.f_257033_.m_7745_(MOVE_EASY_NPC_RESOURCE_LOCATION);
        }
        return cachedMoveEasyNpcItem;
    }

    public static boolean isPlayerHoldingMoveEasyNPC(Player player) {
        if (player == null) {
            return false;
        }
        Item moveEasyNpcItem = ItemUtils.getMoveEasyNPCItem();
        if (moveEasyNpcItem == null || moveEasyNpcItem == Items.f_41852_) {
            return false;
        }
        return ItemUtils.isPlayerHoldingItem(player, moveEasyNpcItem);
    }
}

