/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private AccessManager() {
    }

    public static boolean hasAccess(class_2168 context, UUID uuid) {
        if (context == null || uuid == null) {
            return false;
        }
        if (context.method_9259(2)) {
            log.debug("[Access allowed] Command source with gamemaster permissions accessing EasyNPC with UUID {}!", (Object)uuid);
            return true;
        }
        try {
            class_3222 serverPlayer = context.method_9207();
            boolean hasAccess = AccessManager.hasAccess(serverPlayer, uuid);
            if (hasAccess) {
                log.debug("[Access allowed] Player {} has access to EasyNPC with UUID {}!", (Object)serverPlayer, (Object)uuid);
            } else {
                log.error("[Access denied] Player {} tried to access EasyNPC with UUID {}!", (Object)serverPlayer, (Object)uuid);
            }
            return hasAccess;
        }
        catch (CommandSyntaxException serverPlayerException) {
            try {
                EasyNPC easyNPCEntity;
                class_1297 entity = context.method_9229();
                EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, context.method_9225());
                if (easyNPC != null && easyNPC.getEntity() == entity) {
                    log.debug("[Access allowed] EasyNPC {} and entity {} are the same!", easyNPC, (Object)entity);
                    return true;
                }
                if (easyNPC != null && easyNPC.getEasyNPCOwnerData() != null && entity instanceof EasyNPC && (easyNPCEntity = (EasyNPC)entity).getEasyNPCOwnerData() != null) {
                    boolean ownerDataAccess;
                    OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
                    OwnerDataCapable ownerDataEntity = easyNPCEntity.getEasyNPCOwnerData();
                    boolean bl = ownerDataAccess = !ownerData.hasNPCOwner() && !ownerDataEntity.hasNPCOwner() || ownerData.method_35057() != null && ownerData.method_35057().equals((Object)ownerDataEntity.method_35057());
                    if (ownerDataAccess) {
                        log.debug("[Access allowed] EasyNPC {} and entity {} has same owner data!", easyNPC, (Object)easyNPCEntity);
                    } else {
                        log.error("[Access denied] EasyNPC {} and entity {} has different owner data!", easyNPC, (Object)easyNPCEntity);
                    }
                    return ownerDataAccess;
                }
                log.error("[Access denied] Entity {} tried to access EasyNPC {} with UUID {}!", (Object)entity, easyNPC, (Object)uuid);
                return false;
            }
            catch (CommandSyntaxException entityException) {
                log.debug("[Access skipped] EasyNPC with UUID {} was not executed by a player or entity!", (Object)uuid);
                return true;
            }
        }
    }

    public static boolean hasAccess(class_3222 serverPlayer, EasyNPC<?> easyNPC) {
        return AccessManager.getEasyNPCEntityByUUID(easyNPC.getEntityUUID(), serverPlayer) != null;
    }

    public static boolean hasAccess(class_3222 serverPlayer, UUID uuid) {
        return AccessManager.getEasyNPCEntityByUUID(uuid, serverPlayer) != null;
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, class_3222 serverPlayer) {
        if (serverPlayer == null || uuid == null) {
            return null;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("[{}:{}] Unable to get valid entity!", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        MinecraftServer server = serverPlayer.method_51469().method_8503();
        if (!serverPlayer.method_68878() && !easyNPC.getEasyNPCOwnerData().isNPCOwner(serverPlayer) && server != null && server.method_3835(new class_11560(serverPlayer.method_7334())) < 2) {
            log.error("[{}:{}] Player has no permission to access {}!", (Object)uuid, (Object)serverPlayer, easyNPC);
            return null;
        }
        return easyNPC;
    }
}

