/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block.entity;

import de.markusbordihn.easynpc.block.EasyNPCSpawnerBlock;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class EasyNPCSpawnerBlockEntity
extends class_2586 {
    public static final String NAME = "easy_npc_spawner_entity";
    public static final String SPAWNER_OWNER_TAG = "Owner";
    public static final String UUID_TAG = "UUID";
    private final BaseEasyNPCSpawner spawner;
    private final SpawnerType spawnerType;
    private UUID owner;
    private UUID spawnerUUID;

    public EasyNPCSpawnerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        this(blockEntityType, blockPos, blockState, EasyNPCSpawnerBlock.getSpawnerType(blockState));
    }

    public EasyNPCSpawnerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, SpawnerType spawnerType) {
        super(blockEntityType, blockPos, blockState);
        this.spawnerType = spawnerType;
        this.spawner = new BaseEasyNPCSpawner(spawnerType);
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, EasyNPCSpawnerBlockEntity blockEntity) {
        if (blockEntity.spawner != null) {
            blockEntity.spawner.method_31589(level, blockPos);
        }
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, EasyNPCSpawnerBlockEntity blockEntity) {
        if (blockEntity.spawner != null) {
            blockEntity.spawner.method_31588((class_3218)level, blockPos);
        }
    }

    public SpawnerType getSpawnerType() {
        return this.spawnerType;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(class_1309 livingEntity) {
        this.owner = livingEntity.method_5667();
        this.method_5431();
    }

    public UUID getSpawnerUUID() {
        return this.spawnerUUID;
    }

    public void setSpawnerUUID(UUID spawnerUUID) {
        this.spawnerUUID = spawnerUUID;
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        class_11362 valueOutput = class_11362.method_71458((class_8942)class_8942.field_60348);
        this.spawner.method_8272((class_11372)valueOutput);
        this.spawner.updateSpawnData(valueOutput.method_71475());
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 compoundTag = this.method_38244(provider);
        compoundTag.method_10551("SpawnPotentials");
        return compoundTag;
    }

    public boolean method_11004(int id, int value) {
        return this.spawner.method_8275(this.field_11863, id) || super.method_11004(id, value);
    }

    public BaseEasyNPCSpawner getSpawner() {
        return this.spawner;
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.spawnerUUID = valueInput.method_71426(UUID_TAG, class_4844.field_25122).orElse(UUID.randomUUID());
        this.owner = valueInput.method_71426(SPAWNER_OWNER_TAG, class_4844.field_25122).orElse(null);
        this.spawner.method_8280(this.field_11863, this.field_11867, valueInput);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71468(UUID_TAG, class_4844.field_25122, (Object)Objects.requireNonNullElseGet(this.spawnerUUID, UUID::randomUUID));
        if (this.owner != null) {
            valueOutput.method_71468(SPAWNER_OWNER_TAG, class_4844.field_25122, (Object)this.owner);
        }
        this.spawner.method_8272(valueOutput);
    }
}

