/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.client.model.armpose.ModelArmPoseUtils;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class EasyNPCModel {
    public static boolean setupAnimationStart(EasyNPCRenderStateExtension extension, EasyNPCModelManager modelManager) {
        if (extension == null || modelManager == null) {
            return false;
        }
        EasyNPC<?> easyNPC = EasyNPCModel.getEasyNPC(extension);
        if (easyNPC == null) {
            return false;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return false;
        }
        return EasyNPCModel.setupAnimation(easyNPC, modelData, modelManager);
    }

    public static boolean setupAnimation(EasyNPC<?> easyNPC, ModelDataCapable<?> modelData, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelData == null || modelManager == null) {
            return false;
        }
        modelManager.resetModelParts();
        if (modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        return modelManager.setupModelParts(modelData);
    }

    public static EasyNPC<?> getEasyNPC(EasyNPCRenderStateExtension extension) {
        if (extension == null) {
            return null;
        }
        UUID uuid = extension.getEasyNpcUUID();
        if (uuid == null) {
            return null;
        }
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid);
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, DisplayAttributeDataCapable<?> displayAttributeData, class_2338 blockPos) {
        if (easyNPC == null || displayAttributeData == null || blockPos == null) {
            return 0;
        }
        int entityLightLevel = displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        return easyNPC.getLivingEntity().method_73183().method_8314(class_1944.field_9282, blockPos);
    }

    public static boolean renderEntityNameTag(EasyNPCRenderStateExtension extension, class_4587 poseStack) {
        if (extension == null) {
            return true;
        }
        EasyNPC<?> easyNPC = EasyNPCModel.getEasyNPC(extension);
        if (easyNPC == null) {
            return true;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_1297 entity = easyNPC.getEntity();
        if (player != null && !VisibilityHandler.handleIsCustomNameVisibleToPlayer(easyNPC, (class_1657)player, entity.method_5807())) {
            return false;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return true;
        }
        CustomRotation rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        if (rootRotation != null) {
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-rootRotation.x()));
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-rootRotation.y()));
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-rootRotation.z()));
            poseStack.method_46416(0.0f, -1.0f, 0.0f);
        }
        return true;
    }

    public static void setupAnimationEnd(EasyNPCRenderStateExtension extension, EasyNPCModelManager modelManager) {
        if (extension == null || modelManager == null) {
            return;
        }
        EasyNPCModel.setupArmPoses(extension, modelManager);
    }

    public static void setupArmPoses(EasyNPCRenderStateExtension extension, EasyNPCModelManager modelManager) {
        ModelArmPose leftArmPose;
        if (extension == null) {
            return;
        }
        EasyNPC<?> easyNPC = EasyNPCModel.getEasyNPC(extension);
        if (easyNPC == null) {
            return;
        }
        ModelArmPose rightArmPose = ModelArmPoseUtils.getArmPoseForRightArm(easyNPC);
        if (rightArmPose != null && rightArmPose != ModelArmPose.DEFAULT) {
            EasyNPCModel.applyArmPoseToModelPart(rightArmPose, modelManager.getModelPart(ModelPartType.RIGHT_ARM), true, modelManager.getModelPart(ModelPartType.HEAD), easyNPC);
        }
        if ((leftArmPose = ModelArmPoseUtils.getArmPoseForLeftArm(easyNPC)) != null && leftArmPose != ModelArmPose.DEFAULT) {
            EasyNPCModel.applyArmPoseToModelPart(leftArmPose, modelManager.getModelPart(ModelPartType.LEFT_ARM), false, modelManager.getModelPart(ModelPartType.HEAD), easyNPC);
        }
    }

    public static void applyArmPoseToModelPart(ModelArmPose armPose, class_630 armModelPart, boolean isRightArm, class_630 head, EasyNPC<?> easyNPC) {
        if (armPose == null || armModelPart == null) {
            return;
        }
        switch (armPose) {
            case BOW_AND_ARROW: {
                armModelPart.field_3675 = isRightArm ? -0.1f + (head != null ? head.field_3675 : 0.0f) : 0.1f + (head != null ? head.field_3675 : 0.0f) + 0.4f;
                armModelPart.field_3654 = -1.5707964f + (head != null ? head.field_3654 : 0.0f);
                break;
            }
            case CROSSBOW_HOLD: {
                if (isRightArm) {
                    armModelPart.field_3675 = -0.3f + (head != null ? head.field_3675 : 0.0f);
                    armModelPart.field_3654 = -1.5707964f + (head != null ? head.field_3654 : 0.0f) + 0.1f;
                    break;
                }
                armModelPart.field_3675 = 0.6f + (head != null ? head.field_3675 : 0.0f);
                armModelPart.field_3654 = -1.5f + (head != null ? head.field_3654 : 0.0f);
                break;
            }
            case CROSSBOW_CHARGE: {
                if (isRightArm) {
                    armModelPart.field_3675 = -0.8f;
                    armModelPart.field_3654 = -0.97079635f;
                    break;
                }
                armModelPart.field_3675 = 0.85f;
                armModelPart.field_3654 = -1.5707964f;
                break;
            }
            case SPYGLASS: {
                armModelPart.field_3654 = class_3532.method_15363((float)armModelPart.field_3654, (float)-1.2f, (float)1.2f) - 1.9198622f;
                armModelPart.field_3675 = isRightArm ? 0.5235988f : -0.5235988f;
                break;
            }
            case ATTACKING_WITH_MELEE_WEAPON: {
                float swingProgress = 0.0f;
                if (easyNPC != null && easyNPC.getLivingEntity() != null) {
                    class_1309 livingEntity = easyNPC.getLivingEntity();
                    if (livingEntity.field_6252) {
                        swingProgress = class_3532.method_15363((float)((float)livingEntity.field_6279 / 6.0f), (float)0.0f, (float)1.0f);
                        swingProgress = class_3532.method_15374((float)(swingProgress * (float)Math.PI));
                    }
                }
                armModelPart.field_3654 = swingProgress * -1.8f - 0.3f;
                armModelPart.field_3675 = isRightArm ? -0.3f : 0.3f;
                armModelPart.field_3674 = swingProgress * (isRightArm ? -0.5f : 0.5f);
                break;
            }
            case SPELLCASTING: {
                armModelPart.field_3654 = armModelPart.field_3654 * 0.5f - (float)Math.PI;
                armModelPart.field_3675 = 0.0f;
                break;
            }
            case GUN_HOLD: {
                if (isRightArm) {
                    armModelPart.field_3675 = -0.2f + (head != null ? head.field_3675 : 0.0f);
                    armModelPart.field_3654 = -1.5707964f + (head != null ? head.field_3654 : 0.0f);
                    break;
                }
                armModelPart.field_3675 = 0.4f + (head != null ? head.field_3675 : 0.0f);
                armModelPart.field_3654 = -1.3f + (head != null ? head.field_3654 : 0.0f);
                break;
            }
            case ATTACKING: {
                float attackRotation = 0.8f;
                armModelPart.field_3654 = attackRotation * -0.8f;
                armModelPart.field_3675 = isRightArm ? -0.2f : 0.2f;
                break;
            }
            case CELEBRATING: {
                armModelPart.field_3654 = -0.5f;
                armModelPart.field_3675 = isRightArm ? -0.3f : 0.3f;
                armModelPart.field_3674 = isRightArm ? 0.3f : -0.3f;
                break;
            }
            case DANCING: {
                float danceRotation;
                armModelPart.field_3654 = danceRotation = class_3532.method_15374((float)((float)System.currentTimeMillis() * 0.001f)) * 0.3f;
                armModelPart.field_3675 = isRightArm ? -0.2f : 0.2f;
                armModelPart.field_3674 = isRightArm ? danceRotation * 0.5f : -danceRotation * 0.5f;
                break;
            }
            case CROSSED: {
                if (isRightArm) {
                    armModelPart.field_3654 = -0.8f;
                    armModelPart.field_3675 = 0.6f;
                    break;
                }
                armModelPart.field_3654 = -0.8f;
                armModelPart.field_3675 = -0.6f;
                break;
            }
            case NEUTRAL: {
                armModelPart.field_3654 = 0.0f;
                armModelPart.field_3675 = 0.0f;
                armModelPart.field_3674 = 0.0f;
                break;
            }
        }
    }
}

