/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.screen;

import de.markusbordihn.easynpc.client.gui.InventoryScreenHandler;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4050;
import net.minecraft.class_490;

public class EntityScreenRenderer {
    protected EntityScreenRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderEntity(class_332 guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        int bottom;
        int top;
        int right;
        int left;
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        class_1309 livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config);
        int renderScale = config.scale();
        if (config.scissorBox() != null) {
            CustomScale originalScale;
            float multiplier = config.scissorBox().scaleMultiplier();
            renderScale = (int)((float)config.scale() * multiplier);
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null && (originalScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null) {
                float adjustment = 1.0f / multiplier;
                modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(originalScale.x() * adjustment, originalScale.y() * adjustment, originalScale.z() * adjustment));
            }
        }
        if (config.scissorBox() != null && config.scissorBox().hasCustomScissor()) {
            left = config.x() + config.scissorBox().left();
            right = left + config.scissorBox().width();
            top = config.y() + config.scissorBox().top();
            bottom = top + config.scissorBox().height();
        } else {
            int entityWidth = (int)((float)renderScale * 2.5f);
            int entityHeight = (int)((float)renderScale * 3.0f);
            left = config.x() - entityWidth / 2;
            right = config.x() + entityWidth / 2;
            top = config.y() - entityHeight;
            bottom = config.y() + (int)((float)renderScale * 0.5f);
        }
        try {
            RendererManager.setScreenRendering(true);
            class_490.method_2486((class_332)guiGraphics, (int)left, (int)top, (int)right, (int)bottom, (int)renderScale, (float)0.0f, (float)mouseX, (float)mouseY, (class_1309)livingEntity);
        }
        finally {
            RendererManager.setScreenRendering(false);
        }
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderEntityRaw(class_332 guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        try {
            InventoryScreenHandler.setBypassMixin(true);
            EntityScreenRenderer.renderEntity(guiGraphics, easyNPC, config, mouseX, mouseY);
        }
        finally {
            InventoryScreenHandler.setBypassMixin(false);
        }
    }

    protected static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ModelDataCapable modelData;
        class_1297 entity = easyNPC.getEntity();
        class_1309 livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.method_5648(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft != null) {
                minecraft.field_1690.field_1842 = true;
            } else {
                livingEntity.method_5665(null);
                livingEntity.method_5880(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.method_18380(overrides.entityPose());
        }
    }

    protected static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ModelDataCapable modelData;
        class_1297 entity = easyNPC.getEntity();
        class_1309 livingEntity = easyNPC.getLivingEntity();
        livingEntity.method_5665(backupState.customName);
        livingEntity.method_5880(backupState.shouldShowName);
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null) {
            minecraft.field_1690.field_1842 = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.method_18380(backupState.entityPose);
        }
    }

    protected static class EntityRenderState {
        final class_2561 customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final class_4050 entityPose;

        EntityRenderState(class_1309 livingEntity, EasyNPC<?> easyNPC) {
            this.customName = livingEntity.method_5797();
            this.shouldShowName = livingEntity.method_5733();
            class_310 minecraft = class_310.method_1551();
            this.minecraftHideGui = minecraft != null ? minecraft.field_1690.field_1842 : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().method_18376();
        }
    }
}

