/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7919;

public class MultiStateToggleButton
extends CustomButton {
    public static final int MIN_STATES = 2;
    public static final int MAX_STATES = 9;
    public static final int DEFAULT_WIDTH = 18;
    public static final int DEFAULT_HEIGHT = 18;
    public static final int DEFAULT_SPRITE_WIDTH = 12;
    public static final int DEFAULT_SPRITE_HEIGHT = 12;
    public static final int DEFAULT_SPRITE_X = 3;
    public static final int DEFAULT_SPRITE_Y = 3;
    public static final class_2960 DEFAULT_SPRITE = Constants.TEXTURE_CONFIGURATION;
    private final ToggleState[] states;
    private final class_2960 spriteTexture;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final OnStateChange onStateChange;
    private int currentStateIndex;
    private boolean renderBackground = true;

    public MultiStateToggleButton(int left, int top, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        this(left, top, 18, 18, DEFAULT_SPRITE, 3, 3, 12, 12, states, initialStateIndex, onStateChange);
    }

    public MultiStateToggleButton(int left, int top, int width, int height, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        this(left, top, width, height, DEFAULT_SPRITE, 3, height <= 16 ? 2 : 3, 12, 12, states, initialStateIndex, onStateChange);
    }

    public MultiStateToggleButton(int left, int top, int width, int height, class_2960 spriteTexture, int spriteX, int spriteY, int spriteWidth, int spriteHeight, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        super(left, top, width, height, (class_2561)class_2561.method_43473(), button -> {});
        if (states.length < 2 || states.length > 9) {
            throw new IllegalArgumentException("MultiStateToggleButton requires between 2 and 9 states, but got " + states.length);
        }
        if (initialStateIndex < 0 || initialStateIndex >= states.length) {
            throw new IllegalArgumentException("Initial state index " + initialStateIndex + " is out of bounds for " + states.length + " states");
        }
        this.states = states;
        this.currentStateIndex = initialStateIndex;
        this.onStateChange = onStateChange;
        this.spriteTexture = spriteTexture;
        this.spriteX = spriteX;
        this.spriteY = spriteY;
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.updateTooltip();
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        if (!this.field_22764) {
            return false;
        }
        if (this.method_25351(mouseButtonEvent.comp_4800()) && this.method_25405(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799())) {
            this.method_25354(class_310.method_1551().method_1483());
            this.cycleToNextState();
            this.method_25348(mouseButtonEvent, doubleClick);
            return true;
        }
        return false;
    }

    @Override
    public void renderButton(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.renderBackground) {
            super.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
        }
        ToggleState currentState = this.states[this.currentStateIndex];
        guiGraphics.method_25290(class_10799.field_56883, this.spriteTexture, this.method_46426() + this.spriteX, this.method_46427() + this.spriteY, (float)currentState.spriteOffsetX(), this.field_22763 ? (float)currentState.spriteOffsetY() : (float)(currentState.spriteOffsetY() + this.spriteHeight), this.spriteWidth, this.spriteHeight, 256, 256);
    }

    private void cycleToNextState() {
        this.currentStateIndex = (this.currentStateIndex + 1) % this.states.length;
        this.updateTooltip();
        if (this.onStateChange != null) {
            this.onStateChange.onStateChange(this, this.currentStateIndex);
        }
    }

    private void updateTooltip() {
        ToggleState currentState = this.states[this.currentStateIndex];
        if (currentState.tooltip() != null) {
            this.method_47400(class_7919.method_47407((class_2561)currentState.tooltip()));
        }
    }

    public int getCurrentStateIndex() {
        return this.currentStateIndex;
    }

    public void setCurrentStateIndex(int stateIndex) {
        if (stateIndex >= 0 && stateIndex < this.states.length) {
            this.currentStateIndex = stateIndex;
            this.updateTooltip();
        }
    }

    public ToggleState getCurrentState() {
        return this.states[this.currentStateIndex];
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public boolean method_25405(double x, double y) {
        return this.field_22764 && x >= (double)this.method_46426() && y >= (double)this.method_46427() && x < (double)(this.method_46426() + this.field_22758) && y < (double)(this.method_46427() + this.field_22759);
    }

    public record ToggleState(int spriteOffsetX, int spriteOffsetY, class_2561 tooltip) {
    }

    @FunctionalInterface
    public static interface OnStateChange {
        public void onStateChange(MultiStateToggleButton var1, int var2);
    }
}

