/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_7923;

public class EntityTypeArgument
implements ArgumentType<class_1299<? extends class_1297>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:pig", "minecraft:cow");
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_ENTITY = new SimpleCommandExceptionType((Message)TextComponent.getTranslatedTextRaw("argument.entity.unknown"));

    public static EntityTypeArgument entityType() {
        return new EntityTypeArgument();
    }

    public static class_1299<? extends class_1297> getEntityType(CommandContext<class_2168> commandContext, String entityName) {
        return (class_1299)commandContext.getArgument(entityName, class_1299.class);
    }

    public class_1299<? extends class_1297> parse(StringReader stringReader) throws CommandSyntaxException {
        String entityName = stringReader.getRemaining();
        class_1299 entityType = (class_1299)class_1299.method_5898((String)entityName).orElseThrow(() -> ((SimpleCommandExceptionType)ERROR_UNKNOWN_ENTITY).create());
        stringReader.setCursor(stringReader.getCursor() + entityName.length());
        return entityType;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        Set knownEntityTypes = EntityTypeManager.getUnknownAndSupportedEntityTypes().stream().map(entityType -> class_7923.field_41177.method_10221(entityType).toString()).collect(Collectors.toSet());
        return class_2172.method_9265(knownEntityTypes, (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

