/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogDataSet {
    public static final String DATA_DIALOG_DATA_SET_TAG = "DialogDataSet";
    public static final String DATA_DIALOG_DEFAULT_TAG = "Default";
    public static final String DATA_TYPE_TAG = "Type";
    public static final class_9139<class_9129, DialogDataSet> STREAM_CODEC = new class_9139<class_9129, DialogDataSet>(){

        public DialogDataSet decode(class_9129 registryFriendlyByteBuf) {
            return new DialogDataSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, DialogDataSet dialogDataSet) {
            registryFriendlyByteBuf.method_10794((class_2520)dialogDataSet.createTag());
        }
    };
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final HashMap<String, DialogDataEntry> dialogByLabelMap = new HashMap();
    private final HashMap<UUID, DialogDataEntry> dialogByIdMap = new HashMap();
    private String defaultDialogLabel = "default";
    private DialogType dialogType = DialogType.STANDARD;

    public DialogDataSet() {
    }

    public DialogDataSet(DialogType dialogType) {
        this.dialogType = dialogType;
    }

    public DialogDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public void addDefaultDialog(DialogDataEntry dialogData) {
        if (this.addDialog(dialogData)) {
            this.setDefaultDialog(dialogData);
        }
    }

    public void setDialog(UUID dialogId, DialogDataEntry dialogData) {
        if (dialogData == null) {
            log.error("Dialog data is null, please check your dialog data!");
            return;
        }
        if (this.hasDialog(dialogId)) {
            this.removeDialog(dialogId);
        }
        this.addDialog(dialogData);
    }

    public boolean addDialog(DialogDataEntry dialogData) {
        if (dialogData == null) {
            log.error("Dialog data is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getId() == null) {
            log.error("Dialog id is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getLabel() == null) {
            log.error("Dialog label is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getText() == null || dialogData.getText().isEmpty()) {
            log.error("Dialog text is null or empty, please check your dialog data!");
            return false;
        }
        String dialogLabel = dialogData.getLabel();
        UUID dialogId = dialogData.getId();
        DialogDataEntry existingDialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (existingDialogData != null && !existingDialogData.equals(dialogData)) {
            log.warn("Duplicated dialog with id {} found, will overwrite existing dialog {} with {}!", (Object)dialogId, (Object)dialogData, (Object)existingDialogData);
        }
        this.dialogByLabelMap.put(dialogLabel, dialogData);
        this.dialogByIdMap.put(dialogId, dialogData);
        return true;
    }

    public boolean removeDialog(UUID dialogId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            DialogDataEntry formerDialogData = this.dialogByIdMap.remove(dialogData.getId());
            if (formerDialogData != null) {
                this.dialogByLabelMap.remove(formerDialogData.getLabel());
            }
            return true;
        }
        return false;
    }

    public boolean removeDialogButton(UUID dialogId, UUID dialogButtonId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            return dialogData.removeDialogButton(dialogButtonId);
        }
        return false;
    }

    public List<DialogDataEntry> getDialogsByLabel() {
        return this.dialogByLabelMap.values().stream().sorted(Comparator.comparing(DialogDataEntry::getLabel)).toList();
    }

    public Map<String, DialogDataEntry> getDialogByLabelMap() {
        return this.dialogByLabelMap;
    }

    public DialogDataEntry getDialog(String label) {
        return this.dialogByLabelMap.getOrDefault(label, null);
    }

    public DialogDataEntry getDialog(UUID id) {
        return this.dialogByIdMap.getOrDefault(id, null);
    }

    public UUID getDialogId(String dialogLabel) {
        DialogDataEntry dialogData = this.dialogByLabelMap.getOrDefault(dialogLabel, null);
        if (dialogData != null) {
            return dialogData.getId();
        }
        return null;
    }

    public boolean hasDialog() {
        return !this.dialogByLabelMap.isEmpty();
    }

    public boolean hasDialog(String label) {
        return this.dialogByLabelMap.containsKey(label);
    }

    public boolean hasDialog(UUID id) {
        return this.dialogByIdMap.containsKey(id);
    }

    public boolean hasDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.dialogByIdMap.containsKey(dialogId) && this.dialogByIdMap.get(dialogId).hasDialogButton(dialogButtonId);
    }

    public DialogButtonEntry getDialogButton(UUID dialogId, UUID dialogButtonId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            return dialogData.getDialogButton(dialogButtonId);
        }
        return null;
    }

    public DialogDataEntry getDefaultDialog() {
        return this.dialogByLabelMap.getOrDefault(this.getDefaultDialogLabel(), null);
    }

    public void setDefaultDialog(UUID dialogId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            this.defaultDialogLabel = dialogData.getLabel();
        }
    }

    public void setDefaultDialog(DialogDataEntry dialogData) {
        if (dialogData != null && dialogData.getId() != null && dialogData.getLabel() != null && !dialogData.getText().isEmpty()) {
            this.defaultDialogLabel = dialogData.getLabel();
        }
    }

    public String getDefaultDialogLabel() {
        if (this.hasDialog(this.defaultDialogLabel)) {
            return this.defaultDialogLabel;
        }
        this.defaultDialogLabel = null;
        if (this.hasDialog("default")) {
            this.defaultDialogLabel = "default";
        } else if (this.hasDialog("start")) {
            this.defaultDialogLabel = "start";
        } else if (this.hasDialog("main")) {
            this.defaultDialogLabel = "main";
        }
        if (this.defaultDialogLabel != null) {
            return this.defaultDialogLabel;
        }
        for (DialogDataEntry dialogData : this.dialogByLabelMap.values()) {
            if (dialogData == null || dialogData.getId() == null || dialogData.getLabel() == null || dialogData.getLabel().isEmpty() || dialogData.getText().isEmpty()) continue;
            this.defaultDialogLabel = dialogData.getLabel();
            return this.defaultDialogLabel;
        }
        return null;
    }

    public UUID getDefaultDialogId() {
        DialogDataEntry dialogData = this.dialogByLabelMap.getOrDefault(this.getDefaultDialogLabel(), null);
        return dialogData != null ? dialogData.getId() : null;
    }

    public DialogType getType() {
        return this.dialogType;
    }

    public void load(class_2487 compoundTag) {
        if (compoundTag == null || !compoundTag.method_10545(DATA_DIALOG_DATA_SET_TAG)) {
            return;
        }
        if (compoundTag.method_10545(DATA_TYPE_TAG)) {
            this.dialogType = DialogType.valueOf(compoundTag.method_10558(DATA_TYPE_TAG).orElse(""));
        }
        this.dialogByLabelMap.clear();
        this.dialogByIdMap.clear();
        class_2499 dialogListTag = compoundTag.method_68569(DATA_DIALOG_DATA_SET_TAG);
        for (int i = 0; i < dialogListTag.size(); ++i) {
            class_2487 dialogCompoundTag = dialogListTag.method_68582(i);
            DialogDataEntry dialogData = new DialogDataEntry(dialogCompoundTag);
            this.addDialog(dialogData);
        }
        if (compoundTag.method_10545(DATA_DIALOG_DEFAULT_TAG)) {
            String defaultDialogLabelData = compoundTag.method_10558(DATA_DIALOG_DEFAULT_TAG).orElse("");
            if (!defaultDialogLabelData.isEmpty() && this.dialogByLabelMap.containsKey(defaultDialogLabelData)) {
                this.defaultDialogLabel = defaultDialogLabelData;
            } else {
                log.warn("Invalid default dialog index `{}` found, will use {} instead!", (Object)defaultDialogLabelData, (Object)this.getDefaultDialogLabel());
            }
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2499 dialogListTag = new class_2499();
        for (DialogDataEntry dialogData : this.dialogByLabelMap.values()) {
            if (dialogData == null || dialogData.getId() == null || dialogData.getLabel() == null || dialogData.getText().isEmpty()) continue;
            dialogListTag.add((Object)dialogData.createTag());
        }
        compoundTag.method_10566(DATA_DIALOG_DATA_SET_TAG, (class_2520)dialogListTag);
        if (this.dialogType == DialogType.BASIC && this.dialogByIdMap.size() > 1 || this.dialogType == DialogType.YES_NO && this.dialogByIdMap.size() > 3) {
            this.dialogType = DialogType.STANDARD;
        } else if (this.dialogByIdMap.isEmpty()) {
            this.dialogType = DialogType.NONE;
        } else if (this.dialogType != DialogType.BASIC && this.dialogType != DialogType.YES_NO && this.dialogType != DialogType.STANDARD) {
            this.dialogType = DialogType.CUSTOM;
        }
        compoundTag.method_10582(DATA_TYPE_TAG, this.dialogType.name());
        if (this.defaultDialogLabel != null && !this.defaultDialogLabel.isEmpty() && this.hasDialog(this.defaultDialogLabel)) {
            compoundTag.method_10582(DATA_DIALOG_DEFAULT_TAG, this.defaultDialogLabel);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public String toString() {
        return "DialogDataSet [type=" + String.valueOf((Object)this.dialogType) + ", default=" + this.defaultDialogLabel + ", " + String.valueOf(this.dialogByLabelMap) + "]";
    }
}

