/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scoreboard;

public enum ScoreboardOperation {
    INCREASE("increase", "action.increase_value"),
    DECREASE("decrease", "action.decrease_value"),
    SET("set", "action.set_value");

    private final String commandName;
    private final String translationKey;

    private ScoreboardOperation(String commandName, String translationKey) {
        this.commandName = commandName;
        this.translationKey = translationKey;
    }

    public static ScoreboardOperation fromCommandName(String commandName) {
        if (commandName == null) {
            return INCREASE;
        }
        for (ScoreboardOperation operation : ScoreboardOperation.values()) {
            if (!operation.commandName.equalsIgnoreCase(commandName)) continue;
            return operation;
        }
        return INCREASE;
    }

    public static ScoreboardOperation fromCommand(String command) {
        if (command == null || command.isEmpty()) {
            return INCREASE;
        }
        String[] parts = command.split(":", 2);
        return ScoreboardOperation.fromCommandName(parts[0]);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }
}

