/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.entity.EpicFightEntityType;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import de.markusbordihn.easynpc.entity.UserDefinedEntityRegistry;
import de.markusbordihn.easynpc.entity.UserDefinedEntityType;
import de.markusbordihn.easynpc.entity.VanillaEntityAttributeHelper;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityType {
    public static final Map<ModRawEntityType, class_1299<?>> RAW_TYPE = new EnumMap(ModRawEntityType.class);
    public static final Map<ModNPCEntityType, class_1299<?>> NPC_TYPE = new EnumMap(ModNPCEntityType.class);
    public static final Map<ModCustomEntityType, class_1299<?>> CUSTOM_TYPE = new EnumMap(ModCustomEntityType.class);
    public static final Map<UserDefinedEntityType, class_1299<?>> USER_DEFINED_TYPE = new ConcurrentHashMap();
    public static final Map<EpicFightEntityType, class_1299<?>> EPIC_FIGHT_TYPE = new EnumMap(EpicFightEntityType.class);
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ModEntityType() {
    }

    public static <T extends class_1297> class_1299<T> getEntityType(ModRawEntityType type) {
        if (!RAW_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid raw entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(RAW_TYPE.keySet()));
        }
        return RAW_TYPE.get(type);
    }

    public static <T extends class_1297> class_1299<T> getEntityType(ModNPCEntityType type) {
        if (!NPC_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(NPC_TYPE.keySet()));
        }
        return NPC_TYPE.get(type);
    }

    public static <T extends class_1297> class_1299<T> getEntityType(ModCustomEntityType type) {
        if (!CUSTOM_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(CUSTOM_TYPE.keySet()));
        }
        return CUSTOM_TYPE.get(type);
    }

    public static void registerEntityAttributes() {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            if (modRawEntityType.getAttributes() != null) {
                FabricDefaultAttributeRegistry.register(RAW_TYPE.get(modRawEntityType), (class_5132)modRawEntityType.getAttributes().method_26866());
                continue;
            }
            log.warn("Raw entity type {} does not have attributes defined!", modRawEntityType.getResourceKey());
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            if (((ModNPCEntityType)enum_).getAttributes() != null) {
                FabricDefaultAttributeRegistry.register(NPC_TYPE.get(enum_), (class_5132)((ModNPCEntityType)enum_).getAttributes().method_26866());
                continue;
            }
            log.warn("NPC entity type {} does not have attributes defined!", ((ModNPCEntityType)enum_).getResourceKey());
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            if (((ModCustomEntityType)enum_).getAttributes() != null) {
                FabricDefaultAttributeRegistry.register(CUSTOM_TYPE.get(enum_), (class_5132)((ModCustomEntityType)enum_).getAttributes().method_26866());
                continue;
            }
            log.warn("Custom entity type {} does not have attributes defined!", ((ModCustomEntityType)enum_).getResourceKey());
        }
        for (UserDefinedEntityType type : UserDefinedEntityRegistry.getAvailableEntityTypes()) {
            class_1299<?> baseEntityType = type.getBaseEntityType();
            if (!USER_DEFINED_TYPE.containsKey(type)) continue;
            try {
                class_5132.class_5133 vanillaAttributes;
                boolean bl = false;
                for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
                    if (RAW_TYPE.get(modRawEntityType) != baseEntityType || modRawEntityType.getAttributes() == null) continue;
                    FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)modRawEntityType.getAttributes().method_26866());
                    bl = true;
                    log.debug("Used raw entity type {} attributes for user-defined entity {}", (Object)modRawEntityType.getId(), (Object)type.getId());
                    break;
                }
                if (!bl) {
                    for (Enum enum_ : ModNPCEntityType.values()) {
                        if (NPC_TYPE.get(enum_) != baseEntityType || ((ModNPCEntityType)enum_).getAttributes() == null) continue;
                        FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)((ModNPCEntityType)enum_).getAttributes().method_26866());
                        bl = true;
                        log.debug("Used NPC entity type {} attributes for user-defined entity {}", (Object)((ModNPCEntityType)enum_).getId(), (Object)type.getId());
                        break;
                    }
                }
                if (!bl) {
                    for (Enum enum_ : ModCustomEntityType.values()) {
                        if (CUSTOM_TYPE.get(enum_) != baseEntityType || ((ModCustomEntityType)enum_).getAttributes() == null) continue;
                        FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)((ModCustomEntityType)enum_).getAttributes().method_26866());
                        bl = true;
                        log.debug("Used custom entity type {} attributes for user-defined entity {}", (Object)((ModCustomEntityType)enum_).getId(), (Object)type.getId());
                        break;
                    }
                }
                if (!bl && (vanillaAttributes = VanillaEntityAttributeHelper.getVanillaAttributesForEntityType(baseEntityType)) != null) {
                    FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)vanillaAttributes.method_26866());
                    bl = true;
                    log.info("Used vanilla attributes for user-defined entity {} with base type {}", (Object)type.getId(), baseEntityType);
                }
                if (bl) continue;
                log.error("No attributes found for user-defined entity {} with base type {} - this will cause crashes!", (Object)type.getId(), baseEntityType);
                FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)class_1309.method_26827().method_26866());
                log.warn("Using emergency fallback attributes for user-defined entity {}", (Object)type.getId());
            }
            catch (Exception exception) {
                log.error("Failed to set attributes for user-defined entity {}: {}", (Object)type.getId(), (Object)exception.getMessage(), (Object)exception);
                try {
                    FabricDefaultAttributeRegistry.register(USER_DEFINED_TYPE.get(type), (class_5132)class_1309.method_26827().method_26866());
                    log.warn("Applied emergency fallback attributes for user-defined entity {} due to error", (Object)type.getId());
                }
                catch (Exception fallbackError) {
                    log.error("Even emergency fallback failed for user-defined entity {}: {}", (Object)type.getId(), (Object)fallbackError.getMessage());
                }
            }
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            for (EpicFightEntityType epicFightEntityType : EpicFightEntityType.values()) {
                if (epicFightEntityType.getAttributes() != null) {
                    FabricDefaultAttributeRegistry.register(EPIC_FIGHT_TYPE.get(epicFightEntityType), (class_5132)epicFightEntityType.getAttributes().method_26866());
                    continue;
                }
                log.warn("Epic Fight entity type {} does not have attributes defined!", epicFightEntityType.getResourceKey());
            }
        }
    }

    public static <T extends class_1297> class_1299<T> getEntityType(EpicFightEntityType type) {
        if (!EPIC_FIGHT_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid Epic Fight entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(EPIC_FIGHT_TYPE.keySet()));
        }
        return EPIC_FIGHT_TYPE.get(type);
    }

    static {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            log.info("Registering raw entity type {}", modRawEntityType.getResourceKey());
            RAW_TYPE.put(modRawEntityType, (class_1299)class_2378.method_10226((class_2378)class_7923.field_41177, (String)("easy_npc:" + modRawEntityType.getId()), (Object)modRawEntityType.getBuilder().method_5905(modRawEntityType.getResourceKey())));
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            log.info("Registering NPC entity type {}", ((ModNPCEntityType)enum_).getResourceKey());
            NPC_TYPE.put((ModNPCEntityType)enum_, (class_1299)class_2378.method_10226((class_2378)class_7923.field_41177, (String)("easy_npc:" + ((ModNPCEntityType)enum_).getId()), (Object)((ModNPCEntityType)enum_).getBuilder().method_5905(((ModNPCEntityType)enum_).getResourceKey())));
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            log.info("Registering custom entity type {}", ((ModCustomEntityType)enum_).getResourceKey());
            CUSTOM_TYPE.put((ModCustomEntityType)enum_, (class_1299)class_2378.method_10226((class_2378)class_7923.field_41177, (String)("easy_npc:" + ((ModCustomEntityType)enum_).getId()), (Object)((ModCustomEntityType)enum_).getBuilder().method_5905(((ModCustomEntityType)enum_).getResourceKey())));
        }
        for (UserDefinedEntityType type : UserDefinedEntityRegistry.getAvailableEntityTypes()) {
            log.info("Registering user-defined entity type {}", type.getResourceKey());
            class_1299 entityType = (class_1299)class_2378.method_10226((class_2378)class_7923.field_41177, (String)("easy_npc:" + type.getId()), (Object)type.getBuilder().method_5905(type.getResourceKey()));
            USER_DEFINED_TYPE.put(type, entityType);
            UserDefinedEntityRegistry.registerEntityType(type, entityType);
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            for (EpicFightEntityType epicFightEntityType : EpicFightEntityType.values()) {
                log.info("Registering Epic Fight entity type {}", epicFightEntityType.getResourceKey());
                EPIC_FIGHT_TYPE.put(epicFightEntityType, (class_1299)class_2378.method_10226((class_2378)class_7923.field_41177, (String)("easy_npc:" + epicFightEntityType.getId()), (Object)epicFightEntityType.getBuilder().method_5905(epicFightEntityType.getResourceKey())));
            }
        }
    }
}

