/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_6025;

public interface OwnerDataCapable<T extends class_1314>
extends EasyNPC<T>,
class_6025 {
    public static final String DATA_OWNER_TAG = "Owner";

    public static void registerSyncedOwnerData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Owner Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.OWNER_UUID, class_2945.method_12791(entityClass, (class_2941)class_2943.field_55584));
    }

    default public void setNPCOwnerUUID(UUID uuid) {
        if (uuid == null) {
            this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.empty());
        } else {
            class_10583 entityReference = class_10583.method_73300((UUID)uuid);
            this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.of(entityReference));
        }
    }

    default public UUID getOwnerUUID() {
        class_10583<class_1309> ownerReference = this.method_66287();
        return ownerReference == null ? null : ownerReference.method_66263();
    }

    default public class_10583<class_1309> method_66287() {
        Optional ownerReference = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerReference.orElse(null);
    }

    default public boolean hasNPCOwner() {
        return this.getOwnerUUID() != null;
    }

    default public boolean isNPCOwnedBy(class_1309 livingEntity) {
        return livingEntity != null && this.hasNPCOwner() && livingEntity.method_5667().equals(this.getOwnerUUID());
    }

    default public void setNPCOwner(class_1309 owner) {
        if (owner != null) {
            this.setNPCOwnerUUID(owner.method_5667());
        } else {
            this.setNPCOwnerUUID(null);
        }
    }

    default public String getNPCOwnerName() {
        class_1309 owner = this.method_35057();
        return owner == null ? "" : owner.method_5477().getString();
    }

    default public boolean isNPCOwner(class_3222 serverPlayer) {
        return serverPlayer != null && this.isNPCOwner(serverPlayer.method_5667());
    }

    default public boolean isNPCOwner(UUID uuid) {
        return uuid != null && this.hasNPCOwner() && uuid.equals(this.getOwnerUUID());
    }

    default public class_1309 method_35057() {
        class_1937 level = this.getEntityLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : level.method_18470(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public void defineSynchedOwnerData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(class_11372 valueOutput) {
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null) {
            valueOutput.method_71468(DATA_OWNER_TAG, class_4844.field_25122, (Object)ownerUUID);
        }
    }

    default public void readAdditionalOwnerData(class_11368 valueInput) {
        Optional ownerUUID = valueInput.method_71426(DATA_OWNER_TAG, class_4844.field_25122);
        ownerUUID.ifPresent(this::setNPCOwnerUUID);
    }
}

