/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_4050;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public interface PresetDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final ServerDataAccessor<UUID> CUSTOM_DATA_PRESET_UUID = ServerEntityData.defineId(ServerDataIndex.PRESET_UUID, EntityDataSerializersManager.UUID);
    public static final String PRESET_UUID_TAG = "PresetUUID";
    public static final String UUID_TAG = "UUID";
    public static final String ID_TAG = "id";
    public static final List<String> ENTITY_DATA_VOLATILE_FIELDS = List.of("AbsorptionAmount", "Air", "AngerTime", "DeathTime", "FallDistance", "FallFlying", "Fire", "forge:spawn_type", "HurtByTimestamp", "HurtTime", "Motion", "PortalCooldown");

    default public void importPresetData(class_2487 compoundTag) {
        if (compoundTag == null || compoundTag.method_33133() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().method_18380(class_4050.field_18076);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.method_10545(UUID_TAG) || !compoundTag.method_10545("Pos")) {
            class_2487 existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.method_10545("DialogData")) {
                existingCompoundTag.method_10551("DialogData");
            }
            if (existingCompoundTag.method_10545("ModelData")) {
                existingCompoundTag.method_10551("ModelData");
            }
            if (existingCompoundTag.method_10545("SkinData")) {
                existingCompoundTag.method_10551("SkinData");
            }
            if (existingCompoundTag.method_10545("RenderData")) {
                existingCompoundTag.method_10551("RenderData");
            }
            if (existingCompoundTag.method_10545("ActionData")) {
                existingCompoundTag.method_10551("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.method_10543(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        class_11368 valueInput = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)this.getEntityLevel().method_30349(), (class_2487)compoundTag);
        this.getEntity().method_5651(valueInput);
        CompoundTagUtils.fixLegacyCustomName(this.getEntity(), compoundTag);
    }

    default public class_2487 serializePresetData() {
        class_2487 compoundTag = new class_2487();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.method_10582(ID_TAG, entityTypeId);
        }
        if (!compoundTag.method_10545(PRESET_UUID_TAG)) {
            CompoundTagUtils.writeUUID(compoundTag, PRESET_UUID_TAG, UUID.randomUUID());
        }
        class_11362 tagValueOutput = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)this.getEntityLevel().method_30349());
        this.getEntity().method_5647((class_11372)tagValueOutput);
        class_2487 entityData = tagValueOutput.method_71475();
        for (String entityDataFieldName : ENTITY_DATA_VOLATILE_FIELDS) {
            entityData.method_10551(entityDataFieldName);
        }
        return entityData;
    }

    default public boolean hasPresetUUID() {
        return this.getPresetUUID() != null;
    }

    default public UUID getPresetUUID() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_PRESET_UUID);
    }

    default public void setPresetUUID(UUID uuid) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_PRESET_UUID, uuid);
    }

    default public void defineCustomPresetData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_PRESET_UUID, null);
    }

    default public void addAdditionalPresetData(class_11372 valueOutput) {
        if (this.isServerSideInstance() && this.getPresetUUID() != null) {
            valueOutput.method_71468(PRESET_UUID_TAG, class_4844.field_25122, (Object)this.getPresetUUID());
        }
    }

    default public void readAdditionalPresetData(class_11368 valueInput) {
        Optional presetUUID = valueInput.method_71426(PRESET_UUID_TAG, class_4844.field_25122);
        presetUUID.ifPresent(this::setPresetUUID);
    }
}

