/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;

public interface ProfessionDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final String DATA_PROFESSION_TAG = "Profession";

    public static void registerSyncedProfessionData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Profession Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.PROFESSION, class_2945.method_12791(entityClass, EntityDataSerializersManager.PROFESSION));
    }

    default public Profession getDefaultProfession() {
        return Profession.NONE;
    }

    default public Profession getProfession() {
        return (Profession)((Object)this.getSynchedEntityData(SynchedDataIndex.PROFESSION));
    }

    default public void setProfession(Profession profession) {
        this.setSynchedEntityData(SynchedDataIndex.PROFESSION, profession);
    }

    default public Profession getProfession(String name) {
        return Profession.valueOf(name);
    }

    default public boolean hasProfessions() {
        return false;
    }

    default public Profession[] getProfessions() {
        return Profession.values();
    }

    default public class_2561 getProfessionName() {
        Profession profession = this.getProfession();
        return profession != null ? TextUtils.normalizeName(profession.name()) : TextComponent.getBlankText();
    }

    default public void defineSynchedProfessionData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.PROFESSION, this.getDefaultProfession());
    }

    default public void addAdditionalProfessionData(class_11372 valueOutput) {
        if (this.getProfession() != null) {
            valueOutput.method_71469(DATA_PROFESSION_TAG, this.getProfession().name());
        }
    }

    default public void readAdditionalProfessionData(class_11368 valueInput) {
        Optional profession = valueInput.method_71441(DATA_PROFESSION_TAG);
        if (profession.isPresent() && !((String)profession.get()).isEmpty()) {
            this.setProfession(this.getProfession((String)profession.get()));
        }
    }
}

