/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;

public interface SkinDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_SKIN_DATA_TAG = "SkinData";

    public static void registerSyncedSkinData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Skin Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SKIN_DATA, class_2945.method_12791(entityClass, EntityDataSerializersManager.SKIN_DATA_ENTRY));
    }

    default public int getEntitySkinScaling() {
        return 30;
    }

    default public String getSkinURL() {
        return this.getSkinDataEntry().url();
    }

    default public UUID getSkinUUID() {
        return this.getSkinDataEntry().uuid();
    }

    default public SkinType getSkinType() {
        return this.getSkinDataEntry().type();
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public SkinDataEntry getSkinDataEntry() {
        return (SkinDataEntry)this.getSynchedEntityData(SynchedDataIndex.SKIN_DATA);
    }

    default public void setSkinDataEntry(SkinDataEntry skinDataEntry) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_DATA, skinDataEntry);
    }

    default public void defineSynchedSkinData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SKIN_DATA, new SkinDataEntry());
    }

    default public void addAdditionalSkinData(class_11372 valueOutput) {
        class_2487 skinTag = new class_2487();
        this.getSkinDataEntry().write(skinTag);
        valueOutput.method_71468(EASY_NPC_DATA_SKIN_DATA_TAG, class_2487.field_25128, (Object)skinTag);
    }

    default public void readAdditionalSkinData(class_11368 valueInput) {
        Optional compoundTagData = valueInput.method_71426(EASY_NPC_DATA_SKIN_DATA_TAG, class_2487.field_25128);
        if (compoundTagData.isEmpty()) {
            log.warn("No skin data available for {}.", (Object)this);
            return;
        }
        class_2487 skinTag = (class_2487)compoundTagData.get();
        SkinDataEntry skinDataEntry = new SkinDataEntry(skinTag);
        this.setSkinDataEntry(skinDataEntry);
    }
}

