/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.item.ModItemTags;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3745;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class AttackHandler {
    private AttackHandler() {
    }

    public static void addChargedProjectile(class_1799 weaponItemStack, class_1799 projectileItemStack) {
        weaponItemStack.method_57379(class_9334.field_49649, (Object)class_9278.method_57439((class_1799)projectileItemStack));
    }

    public static boolean isMeleeWeapon(class_1799 itemStack) {
        if (itemStack.method_31573(class_3489.field_42611) || itemStack.method_31573(class_3489.field_42612)) {
            return true;
        }
        if (itemStack.method_31573(ModItemTags.MELEE_WEAPON)) {
            return true;
        }
        if (itemStack.method_7909() instanceof class_1743) {
            return true;
        }
        class_1792 item = itemStack.method_7909();
        String itemName = item.toString().toLowerCase();
        return itemName.contains("sword") || itemName.contains("axe") || itemName.contains("blade") || itemName.contains("dagger") || itemName.contains("knife") || itemName.contains("spear") || itemName.contains("katana") || itemName.contains("rapier") || itemName.contains("saber");
    }

    public static boolean isBowWeapon(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1753 || itemStack.method_31573(ModItemTags.RANGED_WEAPON_BOW);
    }

    public static boolean isCrossbowWeapon(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1764 || itemStack.method_31573(ModItemTags.RANGED_WEAPON_CROSSBOW);
    }

    public static boolean isGunWeapon(class_1799 itemStack) {
        return itemStack.method_31573(ModItemTags.RANGED_WEAPON_GUN);
    }

    public static boolean canFireProjectileWeapon(class_1811 projectileWeaponItem) {
        return projectileWeaponItem instanceof class_1764 || projectileWeaponItem instanceof class_1753;
    }

    public static boolean isHoldingBowWeapon(class_1309 livingEntity) {
        return livingEntity != null && AttackHandler.isBowWeapon(livingEntity.method_6047());
    }

    public static boolean isHoldingCrossbowWeapon(class_1309 livingEntity) {
        return livingEntity != null && AttackHandler.isCrossbowWeapon(livingEntity.method_6047());
    }

    public static boolean isHoldingGunWeapon(class_1309 livingEntity) {
        return livingEntity != null && AttackHandler.isGunWeapon(livingEntity.method_6047());
    }

    public static boolean isHoldingMeleeWeapon(class_1309 livingEntity) {
        return livingEntity != null && AttackHandler.isMeleeWeapon(livingEntity.method_6047());
    }

    public static boolean isHoldingProjectileWeapon(class_1309 livingEntity) {
        return livingEntity != null && livingEntity.method_6047().method_7909() instanceof class_1811;
    }

    public static boolean isHoldingWeapon(class_1309 livingEntity) {
        return AttackHandler.isHoldingMeleeWeapon(livingEntity) || AttackHandler.isHoldingProjectileWeapon(livingEntity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void performDefaultRangedAttack(class_1309 livingEntity, class_1309 targedtedLivingEntity, float damage) {
        if (AttackHandler.isHoldingBowWeapon(livingEntity)) {
            AttackHandler.performBowAttack(livingEntity, targedtedLivingEntity, damage);
            return;
        }
        if (livingEntity instanceof class_3745) {
            class_3745 crossbowAttackMob = (class_3745)livingEntity;
            if (AttackHandler.isHoldingCrossbowWeapon(livingEntity)) {
                AttackHandler.addChargedProjectile(livingEntity.method_6047(), new class_1799((class_1935)class_1802.field_8107, 1));
                crossbowAttackMob.method_24654(livingEntity, 1.6f);
                return;
            }
        }
        if (!AttackHandler.isHoldingGunWeapon(livingEntity)) return;
        AttackHandler.performGunAttack(livingEntity, targedtedLivingEntity, damage);
    }

    public static class_1268 getBowHoldingHand(class_1309 livingEntity) {
        class_1799 itemStack = livingEntity.method_6047();
        return AttackHandler.isBowWeapon(itemStack) ? class_1268.field_5808 : class_1268.field_5810;
    }

    public static class_1268 getCrossbowHoldingHand(class_1309 livingEntity) {
        class_1799 itemStack = livingEntity.method_6047();
        return AttackHandler.isCrossbowWeapon(itemStack) ? class_1268.field_5808 : class_1268.field_5810;
    }

    public static class_1268 getGunHoldingHand(class_1309 livingEntity) {
        class_1799 itemStack = livingEntity.method_6047();
        return AttackHandler.isGunWeapon(itemStack) ? class_1268.field_5808 : class_1268.field_5810;
    }

    public static void performGunAttack(class_1309 livingEntity, class_1309 livingEntityTarget, float damage) {
        class_1799 itemStackWeapon = livingEntity.method_5998(AttackHandler.getGunHoldingHand(livingEntity));
        class_1665 abstractArrow = AttackHandler.getBullet(livingEntity, itemStackWeapon, damage);
        if (AttackHandler.isGunWeapon(livingEntity.method_6047())) {
            double targetX = livingEntityTarget.method_23317() - livingEntity.method_23317();
            double targetY = livingEntityTarget.method_23318() - abstractArrow.method_23318();
            double targetZ = livingEntityTarget.method_23321() - livingEntity.method_23321();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.method_7485(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.method_73183().method_8407().method_5461() * 4));
            livingEntity.method_5783(class_3417.field_15013, 1.0f, 1.0f / (livingEntity.method_59922().method_43057() * 0.4f + 0.8f));
            livingEntity.method_73183().method_8649((class_1297)abstractArrow);
        }
    }

    public static void performBowAttack(class_1309 livingEntity, class_1309 livingEntityTarget, float damage) {
        class_1799 itemStackWeapon;
        class_1799 itemStackProjectile = livingEntity.method_18808(itemStackWeapon = livingEntity.method_5998(AttackHandler.getBowHoldingHand(livingEntity)));
        class_1665 abstractArrow = AttackHandler.getArrow(livingEntity, itemStackWeapon, itemStackProjectile.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemStackProjectile, damage);
        if (AttackHandler.isBowWeapon(livingEntity.method_6047())) {
            double targetX = livingEntityTarget.method_23317() - livingEntity.method_23317();
            double targetY = livingEntityTarget.method_23323(0.3333333333333333) - abstractArrow.method_23318();
            double targetZ = livingEntityTarget.method_23321() - livingEntity.method_23321();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.method_7485(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.method_73183().method_8407().method_5461() * 4));
            livingEntity.method_5783(class_3417.field_14633, 1.0f, 1.0f / (livingEntity.method_59922().method_43057() * 0.4f + 0.8f));
            livingEntity.method_73183().method_8649((class_1297)abstractArrow);
        }
    }

    public static class_1665 getArrow(class_1309 livingEntity, class_1799 itemStackWeapon, class_1799 itemStackProjectile, float damage) {
        return class_1675.method_18813((class_1309)livingEntity, (class_1799)(itemStackProjectile.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemStackProjectile), (float)damage, (class_1799)itemStackWeapon);
    }

    public static class_1665 getBullet(class_1309 livingEntity, class_1799 itemStackWeapon, float damage) {
        Optional item = class_7923.field_41178.method_10223(class_2960.method_60655((String)"easy_npc", (String)"bullet"));
        return item.map(itemReference -> class_1675.method_18813((class_1309)livingEntity, (class_1799)(itemReference != null && itemReference.comp_349() != class_1802.field_8162 ? new class_1799((class_6880)itemReference) : new class_1799((class_1935)class_1802.field_8107)), (float)damage, (class_1799)itemStackWeapon)).orElseGet(() -> class_1675.method_18813((class_1309)livingEntity, (class_1799)new class_1799((class_1935)class_1802.field_8107), (float)damage, (class_1799)itemStackWeapon));
    }

    public static boolean handleIsInvulnerableTo(EasyNPCBase<?> easyNPC, class_1282 damageSource, boolean defaultValue) {
        if (easyNPC.getEntityAttributes().getCombatAttributes().isInvulnerable()) {
            return true;
        }
        CombatAttributes combatAttributes = easyNPC.getEntityAttributes().getCombatAttributes();
        if (damageSource.method_5529() instanceof class_1657) {
            return !combatAttributes.isAttackableByPlayers();
        }
        if (damageSource.method_5529() instanceof class_1588) {
            return !combatAttributes.isAttackableByMonsters();
        }
        return defaultValue;
    }
}

