/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_9306;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradingOfferHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private TradingOfferHandler() {
    }

    private static void updateTradingOffer(TradingDataCapable<?> tradingData, int tradingOfferIndex, Function<class_1914, class_1914> updater) {
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex || tradingOfferIndex < 0) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)updater.apply(merchantOffer));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingMaxUses(TradingDataCapable<?> tradingData, int tradingOfferIndex, int maxUses) {
        TradingOfferHandler.updateTradingOffer(tradingData, tradingOfferIndex, offer -> new class_1914(TradingOfferHandler.getItemCost(offer.method_8246()), TradingOfferHandler.getOptionalItemCost(offer.method_8247()), offer.method_8250(), 0, maxUses, offer.method_19279(), offer.method_19278(), offer.method_21725()));
    }

    public static void setAdvancedTradingXp(TradingDataCapable<?> tradingData, int tradingOfferIndex, int xp) {
        TradingOfferHandler.updateTradingOffer(tradingData, tradingOfferIndex, offer -> new class_1914(TradingOfferHandler.getItemCost(offer.method_8246()), TradingOfferHandler.getOptionalItemCost(offer.method_8247()), offer.method_8250(), offer.method_8249(), offer.method_8248(), xp, offer.method_19278(), offer.method_21725()));
    }

    public static void setAdvancedTradingPriceMultiplier(TradingDataCapable<?> tradingData, int tradingOfferIndex, float priceMultiplier) {
        TradingOfferHandler.updateTradingOffer(tradingData, tradingOfferIndex, offer -> new class_1914(TradingOfferHandler.getItemCost(offer.method_8246()), TradingOfferHandler.getOptionalItemCost(offer.method_8247()), offer.method_8250(), offer.method_8249(), offer.method_8248(), offer.method_19279(), priceMultiplier, offer.method_21725()));
    }

    public static void setAdvancedTradingDemand(TradingDataCapable<?> tradingData, int tradingOfferIndex, int demand) {
        TradingOfferHandler.updateTradingOffer(tradingData, tradingOfferIndex, offer -> new class_1914(TradingOfferHandler.getItemCost(offer.method_8246()), TradingOfferHandler.getOptionalItemCost(offer.method_8247()), offer.method_8250(), offer.method_8249(), offer.method_8248(), offer.method_19279(), offer.method_19278(), demand));
    }

    public static void updateBasicTradingOffers(TradingDataCapable<?> tradingData) {
        if (tradingData.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        class_1916 newMerchantOffers = new class_1916();
        for (class_1914 merchantOffer : merchantOffers) {
            if (!TradingOfferHandler.isValidTradingOffer(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250())) continue;
            class_1914 newMerchantOffer = new class_1914(TradingOfferHandler.getItemCost(merchantOffer.method_8246()), TradingOfferHandler.getOptionalItemCost(merchantOffer.method_8247()), merchantOffer.method_8250(), tradingData.getTradingDataSet().getMaxUses(), tradingData.getTradingDataSet().getRewardedXP(), merchantOffer.method_19278());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        tradingData.setTradingOffers(newMerchantOffers);
    }

    private static boolean isValidTradingOffer(class_1799 itemA, class_1799 itemB, class_1799 itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.method_7960() || itemB != null && !itemB.method_7960()) && !itemResult.method_7960();
    }

    private static class_9306 getItemCost(class_1799 itemStack) {
        return new class_9306((class_1935)(itemStack.method_7960() ? class_1799.field_8037.method_7909() : itemStack.method_7909()), itemStack.method_7947());
    }

    private static Optional<class_9306> getOptionalItemCost(class_1799 itemStack) {
        return itemStack.method_7960() ? Optional.empty() : Optional.of(TradingOfferHandler.getItemCost(itemStack));
    }
}

