/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import de.markusbordihn.easynpc.utils.SpawnerUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_11352;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8942;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends class_1792 {
    public static final String NAME = "easy_npc_preset";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";
    private static final String UUID_TAG = "UUID";

    public EasyNPCPresetItem(class_1792.class_1793 properties) {
        super(properties.method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)NAME))));
    }

    public static UUID getPresetUUID(class_1799 itemStack) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        class_2487 compoundTag = presetData.data();
        return CompoundTagUtils.readUUID(compoundTag, "PresetUUID");
    }

    public static String getCustomName(class_1799 itemStack) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        class_2487 compoundTag = presetData.data();
        if (compoundTag.method_10545(CUSTOM_NAME_TAG)) {
            class_2487 customNameTag = compoundTag.method_68568(CUSTOM_NAME_TAG);
            if (customNameTag.method_10545(TEXT_TAG)) {
                return customNameTag.method_10558(TEXT_TAG).orElse("");
            }
            try {
                JsonObject jsonObject;
                JsonElement jsonElement;
                String customNameString = compoundTag.method_10558(CUSTOM_NAME_TAG).orElse("");
                if (!customNameString.isEmpty() && (jsonElement = JsonParser.parseString((String)customNameString)).isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has(TEXT_TAG)) {
                    return jsonObject.get(TEXT_TAG).getAsString();
                }
            }
            catch (Exception e) {
                log.debug("Could not parse CustomName as legacy JSON format", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean spawnAtPosition(class_2338 blockPos, class_1799 itemStack, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || !presetData.hasEntityType() || !presetData.hasData()) {
            log.error("No valid preset data found in {}!", (Object)itemStack);
            return false;
        }
        class_1299<?> entityType = presetData.entityType();
        class_1297 entity = entityType.method_5883(level, class_3730.field_16465);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", entityType, (Object)level);
            return false;
        }
        class_2487 entityData = presetData.data();
        if (entityData.method_10545(UUID_TAG)) {
            entityData.method_10551(UUID_TAG);
        }
        entity.method_5651(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)level.method_30349(), (class_2487)entityData));
        CompoundTagUtils.fixLegacyCustomName(entity, entityData);
        entity.method_24203((double)((float)blockPos.method_10263() + 0.5f), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + 0.5f));
        if (level.method_8649(entity)) {
            UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
            log.debug("Spawned {} at {} with preset UUID {} and {} in {}", entityType, (Object)blockPos, (Object)presetUUID, (Object)entityData, (Object)level);
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 useOnContext) {
        class_1937 level = useOnContext.method_8045();
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 itemStack = useOnContext.method_8041();
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || !presetData.hasEntityType() || !presetData.hasData()) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return class_1269.field_5814;
        }
        class_2338 blockPos = useOnContext.method_8037();
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof class_2636) {
            class_2636 spawnerBlockEntity = (class_2636)blockEntity;
            class_1917 baseSpawner = spawnerBlockEntity.method_11390();
            class_1952 spawnData = new class_1952(presetData.data(), Optional.empty(), Optional.empty());
            log.debug("Set spawn data {} for spawner {} at {}", (Object)spawnData, (Object)spawnerBlockEntity, (Object)blockPos);
            if (!SpawnerUtils.setNextSpawnData(baseSpawner, (class_1936)level, blockPos, spawnData)) {
                return class_1269.field_5814;
            }
            spawnerBlockEntity.method_5431();
            itemStack.method_7934(1);
            return class_1269.field_21466;
        }
        if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity easyNPCSpawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            BaseEasyNPCSpawner baseEasyNPCSpawner = easyNPCSpawnerBlockEntity.getSpawner();
            class_2487 entityData = presetData.data().method_10553();
            entityData.method_10582("id", class_7923.field_41177.method_10221(presetData.entityType()).toString());
            class_1952 spawnData = new class_1952(entityData, Optional.empty(), Optional.empty());
            log.debug("Set spawn data {} for base NPC spawner {} at {}", (Object)spawnData, (Object)easyNPCSpawnerBlockEntity, (Object)blockPos);
            baseEasyNPCSpawner.method_8277(level, blockPos, spawnData);
            easyNPCSpawnerBlockEntity.method_5431();
            itemStack.method_7934(1);
            return class_1269.field_21466;
        }
        Iterable possibleSpawnPositions = class_2338.method_30512((class_2338)useOnContext.method_8037(), (int)4, (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11034);
        for (class_2338.class_2339 possibleSpawnPosition : possibleSpawnPositions) {
            class_238 aabb = new class_238((class_2338)possibleSpawnPosition).method_1014(0.1);
            class_2338 targetBlockPos = new class_2338(possibleSpawnPosition.method_10263(), possibleSpawnPosition.method_10264() + 1, possibleSpawnPosition.method_10260());
            if (!level.method_8320(targetBlockPos.method_10084()).method_26215() || !level.method_18467(class_1297.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition(targetBlockPos, itemStack, level)) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7885(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1309 livingEntity) {
        return false;
    }

    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 flag) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null) {
            return;
        }
        UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
        if (presetUUID != null) {
            consumer.accept((class_2561)TextComponent.getText(presetUUID.toString()).method_27692(class_124.field_1080));
        }
        consumer.accept((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset").method_27692(class_124.field_1060));
        class_1299<?> entityType = presetData.entityType();
        if (entityType != null) {
            String customName = EasyNPCPresetItem.getCustomName(itemStack);
            if (customName != null) {
                consumer.accept((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName).method_27692(class_124.field_1080));
            }
            consumer.accept((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.method_5897()).method_27692(class_124.field_1080));
        }
    }
}

