/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.renderer;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.utils.ItemUtils;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_746;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_897.class})
public class EasyNPCEntityRendererMixin<T extends class_1297, S extends class_10017> {
    @Inject(method={"method_3933(Lnet/minecraft/class_1297;Lnet/minecraft/class_4604;DDD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onShouldRender(T entity, class_4604 frustum, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof EasyNPC) {
            boolean isInvisible;
            double wandRange;
            double distanceSquared;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            boolean holdingNPCWand = ItemUtils.isPlayerHoldingEasyNPCWand((class_1657)player);
            if (holdingNPCWand && (distanceSquared = entity.method_5858((class_1297)player)) <= (wandRange = 32.0) * wandRange) {
                cir.setReturnValue((Object)true);
                return;
            }
            boolean bl = isInvisible = entity.method_5767() || entity.method_5756((class_1657)player);
            if (isInvisible) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"method_24087(Lnet/minecraft/class_1297;Lnet/minecraft/class_2338;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockLightLevel(T entity, class_2338 blockPos, CallbackInfoReturnable<Integer> cir) {
        EasyNPC easyNPC;
        if (entity instanceof EasyNPC && (easyNPC = (EasyNPC)entity).getEasyNPCDisplayAttributeData() instanceof DisplayAttributeDataCapable) {
            cir.setReturnValue((Object)EasyNPCModel.getEntityLightLevel(easyNPC, easyNPC.getEasyNPCDisplayAttributeData(), blockPos));
        }
    }

    @Inject(method={"method_3926(Lnet/minecraft/class_10017;Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;Lnet/minecraft/class_12075;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSubmitNameTag(S renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        EasyNPCRenderStateExtension renderStateExtension;
        if (renderState instanceof EasyNPCRenderStateExtension && !EasyNPCModel.renderEntityNameTag(renderStateExtension = (EasyNPCRenderStateExtension)renderState, poseStack)) {
            ci.cancel();
        }
    }
}

