/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class PositionCommand
extends Command {
    private PositionCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"position").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"modelPart", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            EasyNPC<?> easyNPC = EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_targets");
            if (easyNPC != null) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                for (ModelPartType partType : modelData.getModelType().getModelParts()) {
                    builder.suggest(partType.name().toLowerCase(Locale.ROOT));
                }
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-3.0f, (float)3.0f)).then(class_2170.method_9244((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-3.0f, (float)3.0f)).then(class_2170.method_9244((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-3.0f, (float)3.0f)).executes(context -> {
            String partString = StringArgumentType.getString((CommandContext)context, (String)"modelPart");
            float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
            float y = FloatArgumentType.getFloat((CommandContext)context, (String)"y");
            float z = FloatArgumentType.getFloat((CommandContext)context, (String)"z");
            ModelPartType modelPartType = ModelPartType.get(partString);
            if (modelPartType == ModelPartType.UNKNOWN) {
                return PositionCommand.sendFailureMessage((class_2168)context.getSource(), "Invalid model part " + partString);
            }
            Collection<? extends EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets");
            return PositionCommand.moveModelPart((class_2168)context.getSource(), easyNPCs, modelPartType, new CustomPosition(x, y, z));
        }))))));
    }

    private static int moveModelPart(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs, ModelPartType modelPartType, CustomPosition position) {
        int moved = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                if (!modelData.getModelType().getModelParts().contains((Object)modelPartType)) {
                    PositionCommand.sendFailureMessage(context, "Model part " + String.valueOf((Object)modelPartType) + " not supported by NPC " + String.valueOf(uuid) + ".");
                    continue;
                }
                modelData.setModelPartPosition(modelPartType, position);
                modelData.setModelPose(modelData.hasChangedModel() ? ModelPose.CUSTOM : ModelPose.DEFAULT);
                ++moved;
                continue;
            }
            PositionCommand.sendFailureMessage(context, "You are not allowed to move the Easy NPC " + String.valueOf(uuid) + " !");
        }
        return PositionCommand.sendPositionFeedback(context, easyNPCs, moved, modelPartType.name().toLowerCase(Locale.ROOT), position.x(), position.y(), position.z());
    }

    private static int sendPositionFeedback(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs, int moved, String partName, float x, float y, float z) {
        if (moved == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return PositionCommand.sendSuccessMessage(context, "Moved model part '" + partName + "' of NPC " + easyNPC.getEntity().method_5476().getString() + " to x:" + x + ", y:" + y + ", z:" + z);
        }
        if (moved > 1) {
            return PositionCommand.sendSuccessMessage(context, "Moved model part '" + partName + "' of " + moved + " of " + easyNPCs.size() + " selected Easy NPCs to x:" + x + ", y:" + y + ", z:" + z);
        }
        return PositionCommand.sendFailureMessage(context, "Nothing was moved.");
    }
}

