/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static boolean setNextSpawnData(BaseSpawner spawner, LevelAccessor level, BlockPos blockPos, SpawnData spawnData) {
        try {
            Method method = SpawnerUtils.findSetNextSpawnDataMethod();
            method.invoke((Object)spawner, level, blockPos, spawnData);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to call setNextSpawnData for {} at {} with {}", (Object)spawner, (Object)blockPos, (Object)spawnData, (Object)e);
            return false;
        }
    }

    private static Method findSetNextSpawnDataMethod() {
        for (Method method : BaseSpawner.class.getDeclaredMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 3 || !LevelAccessor.class.isAssignableFrom(params[0]) || !BlockPos.class.isAssignableFrom(params[1]) || !SpawnData.class.isAssignableFrom(params[2])) continue;
            method.setAccessible(true);
            return method;
        }
        log.error("Could not find method setNextSpawnData(LevelAccessor, BlockPos, SpawnData)");
        return null;
    }
}

