/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.commands.ModArgumentTypes;
import de.markusbordihn.easynpc.compat.CompatHandler;
import de.markusbordihn.easynpc.compat.CompatManager;
import de.markusbordihn.easynpc.component.ModDataComponents;
import de.markusbordihn.easynpc.config.Config;
import de.markusbordihn.easynpc.debug.DebugManager;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.item.ModItems;
import de.markusbordihn.easynpc.menu.MenuHandler;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.syncher.ModEntityDataSerializers;
import java.util.Optional;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="easy_npc")
public class EasyNPCMain {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public EasyNPCMain(IEventBus modEventBus, ModContainer modContainer) {
        log.info("Initializing {} (NeoForge) ...", (Object)"Easy NPC");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
        if (version.isPresent() && "MOD_DEV".equals(version.get())) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC: Core");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Constants.GAME_DIR = FMLPaths.GAMEDIR.get();
        Constants.CONFIG_DIR = FMLPaths.CONFIGDIR.get();
        log.info("{} Configuration ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Config.register(FMLEnvironment.dist == Dist.DEDICATED_SERVER);
        log.info("{} Common Data Files ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        DataFileHandler.registerCommonDataFiles();
        log.info("{} Entity Data Serializers ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModEntityDataSerializers.ENTITY_DATA_SERIALIZERS.register(modEventBus);
        log.info("{} Compatibility Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CompatManager.registerCompatHandler(new CompatHandler());
        log.info("{} Command Argument Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModArgumentTypes.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        log.info("{} Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModEntityType.ENTITY_TYPES.register(modEventBus);
        log.info("{} Blocks ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModBlocks.BLOCKS.register(modEventBus);
        log.info("{} Blocks Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModBlocks.BLOCK_ENTITY_TYPES.register(modEventBus);
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModItems.ITEMS.register(modEventBus);
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        MenuManager.registerMenuHandler(new MenuHandler());
        log.info("{} Mod Data Components ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModDataComponents.DATA_COMPONENTS.register(modEventBus);
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        modEventBus.addListener(event -> {
            NetworkHandlerManager.registerHandler(new NetworkHandler());
            NetworkHandler.registerNetworkHandler(event);
            NetworkHandlerManager.registerNetworkMessages(NetworkHandlerManagerType.BOTH);
        });
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
    }
}

