/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttributesInterface;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributes;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributes;
import de.markusbordihn.easynpc.data.attribute.MovementAttributes;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class EntityAttributes {
    public static final String ENTITY_ATTRIBUTE_TAG = "EntityAttribute";
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityAttributes> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EntityAttributes>(){

        public EntityAttributes decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new EntityAttributes(registryFriendlyByteBuf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, EntityAttributes value) {
            registryFriendlyByteBuf.writeNbt((Tag)value.createTag());
        }
    };
    private final Map<EntityAttributeType, EntityAttributesInterface> attributeMap = new EnumMap<EntityAttributeType, EntityAttributesInterface>(EntityAttributeType.class);

    public EntityAttributes() {
        this.setAttribute(EntityAttributeType.COMBAT, new CombatAttributes());
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, new EnvironmentalAttributes());
        this.setAttribute(EntityAttributeType.INTERACTION, new InteractionAttributes());
        this.setAttribute(EntityAttributeType.MOVEMENT, new MovementAttributes());
    }

    public EntityAttributes(CompoundTag compoundTag) {
        this();
        this.load(compoundTag);
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.contains(ENTITY_ATTRIBUTE_TAG) || compoundTag.getCompound(ENTITY_ATTRIBUTE_TAG).isEmpty()) {
            return;
        }
        CompoundTag entityAttributeTag = compoundTag.getCompound(ENTITY_ATTRIBUTE_TAG);
        this.setAttribute(EntityAttributeType.COMBAT, CombatAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, EnvironmentalAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.INTERACTION, InteractionAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.MOVEMENT, MovementAttributes.decode(entityAttributeTag));
    }

    public boolean hasAttribute(EntityAttributeType entityAttributeType) {
        return this.attributeMap.containsKey((Object)entityAttributeType);
    }

    public EntityAttributesInterface getAttribute(EntityAttributeType entityAttributeType) {
        return this.attributeMap.get((Object)entityAttributeType);
    }

    public void setAttribute(EntityAttributeType entityAttributeType, EntityAttributesInterface attribute) {
        this.attributeMap.put(entityAttributeType, attribute);
    }

    public boolean hasCombatAttributes() {
        return this.hasAttribute(EntityAttributeType.COMBAT);
    }

    public CombatAttributes getCombatAttributes() {
        return (CombatAttributes)this.getAttribute(EntityAttributeType.COMBAT);
    }

    public void setCombatAttributes(CombatAttributes combatAttributes) {
        this.setAttribute(EntityAttributeType.COMBAT, combatAttributes);
    }

    public boolean hasEnvironmentalAttributes() {
        return this.hasAttribute(EntityAttributeType.ENVIRONMENTAL);
    }

    public EnvironmentalAttributes getEnvironmentalAttributes() {
        return (EnvironmentalAttributes)this.getAttribute(EntityAttributeType.ENVIRONMENTAL);
    }

    public void setEnvironmentalAttributes(EnvironmentalAttributes environmentalAttributes) {
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, environmentalAttributes);
    }

    public boolean hasInteractionAttributes() {
        return this.hasAttribute(EntityAttributeType.INTERACTION);
    }

    public InteractionAttributes getInteractionAttributes() {
        return (InteractionAttributes)this.getAttribute(EntityAttributeType.INTERACTION);
    }

    public void setInteractionAttributes(InteractionAttributes interactionAttributes) {
        this.setAttribute(EntityAttributeType.INTERACTION, interactionAttributes);
    }

    public boolean hasMovementAttributes() {
        return this.hasAttribute(EntityAttributeType.MOVEMENT);
    }

    public MovementAttributes getMovementAttributes() {
        return (MovementAttributes)this.getAttribute(EntityAttributeType.MOVEMENT);
    }

    public void setMovementAttributes(MovementAttributes movementAttributes) {
        this.setAttribute(EntityAttributeType.MOVEMENT, movementAttributes);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag entityAttributeTag = new CompoundTag();
        this.attributeMap.forEach((type, attribute) -> {
            if (attribute instanceof CombatAttributes) {
                CombatAttributes combatAttributes = (CombatAttributes)attribute;
                combatAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof EnvironmentalAttributes) {
                EnvironmentalAttributes environmentalAttributes = (EnvironmentalAttributes)attribute;
                environmentalAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof InteractionAttributes) {
                InteractionAttributes interactionAttributes = (InteractionAttributes)attribute;
                interactionAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof MovementAttributes) {
                MovementAttributes movementAttributes = (MovementAttributes)attribute;
                movementAttributes.encode(entityAttributeTag);
            }
        });
        compoundTag.put(ENTITY_ATTRIBUTE_TAG, (Tag)entityAttributeTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

