/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCModelManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final ModelPart rootModelPart;
    private final Function<ResourceLocation, RenderType> renderType;
    private final Map<ModelPartType, CustomPosition> defaultModelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    private final Map<ModelPartType, CustomRotation> defaultModelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    private final Map<ModelPartType, CustomScale> defaultModelPartScaleMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
    private final Map<ModelPartType, Boolean> defaultModelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    private final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);

    public EasyNPCModelManager(ModelPart rootModelPart) {
        this(rootModelPart, RenderType::entityCutoutNoCull);
    }

    public EasyNPCModelManager(ModelPart rootModelPart, Function<ResourceLocation, RenderType> renderType) {
        this.rootModelPart = rootModelPart;
        this.renderType = renderType;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, String modelPartName) {
        if (this.rootModelPart != null && this.rootModelPart.hasChild(modelPartName)) {
            return this.defineModelPart(modelPartType, this.rootModelPart.getChild(modelPartName));
        }
        log.error("Model part '{}' not found for model part type '{}' in {}.", (Object)modelPartName, (Object)modelPartType.getTagName(), (Object)this.rootModelPart);
        return this;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.setDefaultModelPartPosition(modelPartType, new CustomPosition(modelPart.x, modelPart.y, modelPart.z));
        this.setDefaultModelPartRotation(modelPartType, new CustomRotation(modelPart.xRot, modelPart.yRot, modelPart.zRot));
        this.setDefaultModelPartScale(modelPartType, new CustomScale(modelPart.xScale, modelPart.yScale, modelPart.zScale));
        this.setDefaultModelPartVisibility(modelPartType, modelPart.visible);
        this.setDefaultModelPart(modelPartType, modelPart);
        return this;
    }

    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.defaultModelPartPositionMap.put(modelPartType, customPosition);
    }

    public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.defaultModelPartRotationMap.put(modelPartType, rotation);
    }

    public void setDefaultModelPartScale(ModelPartType modelPartType, CustomScale customScale) {
        this.defaultModelPartScaleMap.put(modelPartType, customScale);
    }

    public void setDefaultModelPartVisibility(ModelPartType modelPartType, boolean isVisible) {
        this.defaultModelPartVisibilityMap.put(modelPartType, isVisible);
    }

    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    public ModelPart getModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.get((Object)modelPartType);
    }

    public boolean setupModelParts(ModelDataCapable<?> modelData) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        boolean hasChangedModelPart = false;
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            CustomScale customScale;
            CustomRotation customRotation;
            CustomPosition customPosition;
            ModelPartType partType = entry.getKey();
            ModelPart modelPart = entry.getValue();
            if (partType == ModelPartType.HAT) continue;
            Boolean visibility = modelData.getModelPartVisibility(partType);
            if (Boolean.FALSE.equals(visibility)) {
                modelPart.visible = false;
                continue;
            }
            if (Boolean.TRUE.equals(visibility) && Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)partType))) {
                modelPart.visible = true;
            }
            if ((customPosition = modelData.getModelPartPosition(partType)) != null && customPosition.hasChanged()) {
                modelPart.x += customPosition.x();
                modelPart.y += customPosition.y();
                modelPart.z += customPosition.z();
                hasChangedModelPart = true;
            }
            if ((customRotation = modelData.getModelPartRotation(partType)) != null && customRotation.hasChanged()) {
                modelPart.xRot += customRotation.x();
                modelPart.yRot += customRotation.y();
                modelPart.zRot += customRotation.z();
                hasChangedModelPart = true;
            }
            if ((customScale = modelData.getModelPartScale(partType)) == null || !customScale.hasChanged()) continue;
            CustomScale defaultScale = this.defaultModelPartScaleMap.get((Object)partType);
            if (defaultScale != null) {
                modelPart.xScale = defaultScale.x() * customScale.x();
                modelPart.yScale = defaultScale.y() * customScale.y();
                modelPart.zScale = defaultScale.z() * customScale.z();
            } else {
                modelPart.xScale = customScale.x();
                modelPart.yScale = customScale.y();
                modelPart.zScale = customScale.z();
            }
            hasChangedModelPart = true;
        }
        this.syncModelParts(modelData);
        return hasChangedModelPart;
    }

    public void syncModelParts(ModelDataCapable<?> modelData) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return;
        }
        ModelPart hatModelPart = this.modelPartMap.get((Object)ModelPartType.HAT);
        ModelPart headModelPart = this.modelPartMap.get((Object)ModelPartType.HEAD);
        if (hatModelPart != null && headModelPart != null && Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)ModelPartType.HAT))) {
            if (modelData.getModelType().requiresHatSync()) {
                hatModelPart.copyFrom(headModelPart);
            } else {
                hatModelPart.visible = headModelPart.visible;
            }
        }
    }

    public void resetModelParts() {
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            ModelPartType modelPartType = entry.getKey();
            ModelPart modelPartToRest = entry.getValue();
            if (modelPartType == ModelPartType.HAT) continue;
            CustomPosition customPosition = this.defaultModelPartPositionMap.get((Object)modelPartType);
            CustomRotation customRotation = this.defaultModelPartRotationMap.get((Object)modelPartType);
            CustomScale customScale = this.defaultModelPartScaleMap.get((Object)modelPartType);
            Boolean isVisible = this.defaultModelPartVisibilityMap.get((Object)modelPartType);
            if (customPosition != null) {
                modelPartToRest.setPos(customPosition.x(), customPosition.y(), customPosition.z());
            }
            if (customRotation != null) {
                modelPartToRest.setRotation(customRotation.x(), customRotation.y(), customRotation.z());
            }
            if (customScale != null) {
                modelPartToRest.xScale = customScale.x();
                modelPartToRest.yScale = customScale.y();
                modelPartToRest.zScale = customScale.z();
            }
            if (isVisible == null) continue;
            modelPartToRest.visible = isVisible;
        }
    }
}

