/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardData;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextFormattingCodes;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DialogUtils {
    private static final String MACRO_NPC_STRING = "@npc";
    private static final String MACRO_INITIATOR_STRING = "@initiator";
    private static final Pattern SCORE_PATTERN = Pattern.compile("@score\\(([a-zA-Z0-9_.-]+)\\)");
    private static final int MAX_DIALOG_LINE_LENGTH = 178;
    private static final int MAX_SMALL_BUTTON_NAME_LENGTH = 20;

    protected DialogUtils() {
    }

    public static String parseDialogText(Component component, DialogMetaData dialogMetaData) {
        if (dialogMetaData == null) {
            return component.getString();
        }
        return DialogUtils.parseDialogText(component.getString(), dialogMetaData.livingEntity(), dialogMetaData.player(), dialogMetaData.scoreboardData());
    }

    public static String parseDialogText(String text, LivingEntity entity, Player player) {
        return DialogUtils.parseDialogText(text, entity, player, null);
    }

    public static String parseDialogText(String text, LivingEntity entity, Player player, ScoreboardData scoreboardData) {
        if (DialogUtils.hasDialogMacros(text)) {
            if (entity != null) {
                text = text.replace(MACRO_NPC_STRING, entity.getName().getString());
            }
            if (player != null) {
                text = text.replace(MACRO_INITIATOR_STRING, player.getName().getString());
                if (scoreboardData != null) {
                    Matcher matcher = SCORE_PATTERN.matcher(text);
                    StringBuilder sb = new StringBuilder();
                    while (matcher.find()) {
                        String objectiveName = matcher.group(1);
                        int score = scoreboardData.getScore(objectiveName);
                        matcher.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(score)));
                    }
                    matcher.appendTail(sb);
                    text = sb.toString();
                }
            }
        }
        text = TextFormattingCodes.parseTextLineBreaks(text);
        text = TextFormattingCodes.parseTextFormattingCodes(text);
        return text;
    }

    public static boolean hasDialogMacros(Component component) {
        return component != null && DialogUtils.hasDialogMacros(component.getString());
    }

    public static boolean hasDialogMacros(String text) {
        return text != null && !text.isEmpty() && (text.contains(MACRO_NPC_STRING) || text.contains(MACRO_INITIATOR_STRING) || text.contains("@score("));
    }

    public static String generateButtonLabel(String name) {
        return DialogUtils.generateLabel(name, "button", 32);
    }

    public static String generateDialogLabel(String name) {
        return DialogUtils.generateLabel(name, "dialog", 32);
    }

    private static String generateLabel(String name, String type, int maxLength) {
        if (name == null || name.isEmpty()) {
            return type + "_" + UUID.randomUUID().toString().substring(0, 8).replace("-", "").toLowerCase(Locale.ROOT);
        }
        String label = name.trim().toLowerCase(Locale.ROOT);
        label = label.replace(" ", "_");
        return (label = label.replaceAll("[^a-z0-9_]", "")).length() > maxLength ? label.substring(0, maxLength) : label;
    }

    public static int getNumbersOfDialogLines(Component component, Font font) {
        return DialogUtils.getNumbersOfDialogLines(component, 178, font);
    }

    public static int getNumbersOfDialogLines(String text, Font font) {
        return DialogUtils.getNumbersOfDialogLines(text, 178, font);
    }

    public static int getNumbersOfDialogLines(String text, int maxLineLength, Font font) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return DialogUtils.getNumbersOfDialogLines((Component)TextComponent.getText(text), maxLineLength, font);
    }

    public static int getNumbersOfDialogLines(Component component, int maxLineLength, Font font) {
        return font.split((FormattedText)component, maxLineLength).size();
    }

    public static DialogDataSet getBasicDialog(String dialog) {
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.BASIC);
        DialogDataEntry dialogData = new DialogDataEntry("Basic Dialog", dialog);
        dialogDataSet.addDialog(dialogData);
        return dialogDataSet;
    }

    public static DialogDataSet getYesNoDialog(String dialogText, String yesButtonText, String noButtonText, String yesDialogText, String noDialogText) {
        ActionDataSet yesActionDataSet = new ActionDataSet();
        yesActionDataSet.add(new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, "yes_answer"));
        Set<DialogButtonEntry> buttons = DialogUtils.getDialogButtonEntries(yesButtonText, noButtonText, yesActionDataSet);
        DialogDataSet dialogDataSet = new DialogDataSet(DialogType.YES_NO);
        dialogDataSet.addDefaultDialog(new DialogDataEntry("question", "Question Dialog", dialogText, buttons));
        dialogDataSet.addDialog(new DialogDataEntry("yes_answer", "Yes Dialog", yesDialogText));
        dialogDataSet.addDialog(new DialogDataEntry("no_answer", "No Dialog", noDialogText));
        return dialogDataSet;
    }

    private static Set<DialogButtonEntry> getDialogButtonEntries(String yesButtonText, String noButtonText, ActionDataSet yesActionDataSet) {
        ActionDataSet noActionDataSet = new ActionDataSet();
        noActionDataSet.add(new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, "no_answer"));
        DialogButtonEntry yesButtonData = new DialogButtonEntry(yesButtonText, "yes_button", yesActionDataSet);
        DialogButtonEntry noButtonData = new DialogButtonEntry(noButtonText, "no_button", noActionDataSet);
        LinkedHashSet<DialogButtonEntry> buttons = new LinkedHashSet<DialogButtonEntry>();
        buttons.add(yesButtonData);
        buttons.add(noButtonData);
        return buttons;
    }

    public static DialogScreenLayout getDialogScreenLayout(DialogDataEntry dialogData, Font font) {
        boolean hasLargeButtonName;
        if (dialogData == null) {
            return DialogScreenLayout.UNKNOWN;
        }
        boolean hasText = !dialogData.getText().isBlank();
        int numberOfButtons = dialogData.getNumberOfDialogButtons();
        if (!hasText) {
            return DialogScreenLayout.UNKNOWN;
        }
        Component dialogText = dialogData.getDialogText();
        boolean hasDialogMacros = DialogUtils.hasDialogMacros(dialogText);
        if (TextFormattingCodes.hasTextLinebreakCodes(dialogText)) {
            dialogText = TextFormattingCodes.parseTextLineBreaks(dialogText);
        }
        int numberOfLines = DialogUtils.getNumbersOfDialogLines(dialogText, font);
        if (hasDialogMacros) {
            numberOfLines += 20;
        }
        int maxButtonNameLength = 0;
        if (numberOfButtons > 0) {
            for (DialogButtonEntry buttonData : dialogData.getDialogButtons()) {
                int buttonNameLength = buttonData.name().length();
                if (buttonNameLength <= maxButtonNameLength) continue;
                maxButtonNameLength = buttonNameLength;
            }
        }
        boolean bl = hasLargeButtonName = maxButtonNameLength > 20;
        if (numberOfLines <= 6) {
            if (numberOfButtons == 0) {
                return DialogScreenLayout.COMPACT_TEXT_ONLY;
            }
            if (numberOfButtons == 1) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON;
            }
            if (numberOfButtons == 2) {
                return hasLargeButtonName ? DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS : DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS;
            }
            if (numberOfButtons == 3) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS;
            }
            if (numberOfButtons == 4) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS;
            }
            if (numberOfButtons == 5) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS;
            }
            if (numberOfButtons == 6) {
                return DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS;
            }
        }
        if (numberOfButtons == 0) {
            return DialogScreenLayout.TEXT_ONLY;
        }
        if (numberOfButtons == 1) {
            return DialogScreenLayout.TEXT_WITH_ONE_BUTTON;
        }
        if (numberOfButtons == 2) {
            return DialogScreenLayout.TEXT_WITH_TWO_BUTTONS;
        }
        if (numberOfButtons == 3) {
            return DialogScreenLayout.TEXT_WITH_THREE_BUTTONS;
        }
        if (numberOfButtons == 4) {
            return DialogScreenLayout.TEXT_WITH_FOUR_BUTTONS;
        }
        if (numberOfButtons == 5) {
            return DialogScreenLayout.TEXT_WITH_FIVE_BUTTONS;
        }
        if (numberOfButtons == 6) {
            return DialogScreenLayout.TEXT_WITH_SIX_BUTTONS;
        }
        return DialogScreenLayout.UNKNOWN;
    }
}

