/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import java.util.Locale;

public enum SkinModel {
    ALLAY,
    BOGGED(true),
    CAT,
    CHICKEN,
    CREEPER,
    FAIRY,
    FOX,
    DROWNED,
    EVOKER,
    ENDER_MAN,
    HORSE,
    HUMANOID_SLIM(true),
    HUMANOID(true),
    HUSK(true),
    ILLAGER,
    ILLUSIONER,
    IRON_GOLEM,
    ORC,
    PIG,
    PIGLIN,
    PIGLIN_BRUTE,
    PILLAGER,
    PLAYER,
    SKELETON(true),
    SPIDER,
    VEX,
    VILLAGER(true),
    VINDICATOR,
    WITCH,
    WOLF,
    ZOMBIE_VILLAGER(true),
    ZOMBIE(true),
    ZOMBIFIED_PIGLIN,
    STRAY,
    WITHER_SKELETON;

    private final boolean hasArmourersWorkshopSupport;

    private SkinModel() {
        this(false);
    }

    private SkinModel(boolean hasArmourersWorkshopSupport) {
        this.hasArmourersWorkshopSupport = hasArmourersWorkshopSupport;
    }

    public static SkinModel get(String skinModel) {
        if (skinModel == null || skinModel.isEmpty()) {
            return HUMANOID;
        }
        try {
            return SkinModel.valueOf(skinModel);
        }
        catch (IllegalArgumentException e) {
            return HUMANOID;
        }
    }

    public boolean hasArmourersWorkshopSupport() {
        return this.hasArmourersWorkshopSupport;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT).replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "");
    }
}

