/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SpiderRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Spider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpiderRawRenderer
extends SpiderRenderer<Spider>
implements EasyNPCEntityRenderer {
    protected static final Map<SpiderRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(SpiderRaw.VariantType.class), map -> {
        map.put(SpiderRaw.VariantType.CAVE_SPIDER, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/spider/cave_spider.png"));
        map.put(SpiderRaw.VariantType.SPIDER, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/spider/spider.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)SpiderRaw.VariantType.SPIDER);
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public SpiderRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(Spider entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

