/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.HumanoidNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;

public class PlayerRenderer<T extends PathfinderMob>
extends LivingEntityRenderer<T, PlayerModel<T>>
implements EasyNPCEntityRenderer {
    protected static final Map<HumanoidNPC.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(HumanoidNPC.VariantType.class), map -> {
        map.put(HumanoidNPC.VariantType.ALEX, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/alex.png"));
        map.put(HumanoidNPC.VariantType.ARI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/ari.png"));
        map.put(HumanoidNPC.VariantType.EFE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/efe.png"));
        map.put(HumanoidNPC.VariantType.KAI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/kai.png"));
        map.put(HumanoidNPC.VariantType.MAKENA, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/makena.png"));
        map.put(HumanoidNPC.VariantType.NOOR, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/noor.png"));
        map.put(HumanoidNPC.VariantType.STEVE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png"));
        map.put(HumanoidNPC.VariantType.SUNNY, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/sunny.png"));
        map.put(HumanoidNPC.VariantType.ZURI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/zuri.png"));
        map.put(HumanoidNPC.VariantType.JAYJASONBO, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/jayjasonbo.png"));
        map.put(HumanoidNPC.VariantType.PROFESSOR_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/professor_01.png"));
        map.put(HumanoidNPC.VariantType.SECURITY_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/security_01.png"));
        map.put(HumanoidNPC.VariantType.KNIGHT_01, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/knight_01.png"));
        map.put(HumanoidNPC.VariantType.KNIGHT_02, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid/knight_02.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)HumanoidNPC.VariantType.STEVE);

    public PlayerRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public PlayerRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slim), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityPlayerTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getCustomTexture(SkinDataCapable<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    @Override
    public ResourceLocation getRemoteTexture(SkinDataCapable<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getTextureByVariant(Enum variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

