/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.type;

import java.util.Locale;

public enum ValueType {
    BOOLEAN,
    DOUBLE,
    INTEGER,
    STRING;


    public static ValueType get(String valueType) {
        if (valueType == null || valueType.isEmpty()) {
            return STRING;
        }
        try {
            return ValueType.valueOf(valueType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return STRING;
        }
    }

    public String getTypeName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isValidValue(String value) {
        if (value == null) {
            return false;
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                boolean var2_2;
                yield var2_2 = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
            }
            case 2 -> {
                try {
                    boolean var2_3;
                    Integer.parseInt(value);
                    yield var2_3 = true;
                }
                catch (NumberFormatException e) {
                    boolean var2_4;
                    yield var2_4 = false;
                }
            }
            case 1 -> {
                try {
                    boolean var2_5;
                    Double.parseDouble(value);
                    yield var2_5 = true;
                }
                catch (NumberFormatException e) {
                    boolean var2_6;
                    yield var2_6 = false;
                }
            }
            case 3 -> {
                boolean var2_7;
                yield var2_7 = true;
            }
        };
    }

    public Object parseValue(String value) {
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "' for type " + String.valueOf((Object)this));
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Boolean.parseBoolean(value);
            case 2 -> Integer.parseInt(value);
            case 1 -> Double.parseDouble(value);
            case 3 -> value;
        };
    }
}

