/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;

public class CrossbowAttackGoal<T extends EasyNPC<?>>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final PathfinderMob pathfinderMob;
    private final CrossbowAttackMob crossbowAttackMob;
    private int attackDelay;
    private CrossbowState crossbowState;
    private int seeTime;
    private int updatePathDelay;

    public CrossbowAttackGoal(T easyNPC, double speedModifier, float attackRange) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.crossbowAttackMob = easyNPC.getCrossbowAttackMob();
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRange * attackRange;
        this.crossbowState = CrossbowState.UNCHARGED;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.crossbowAttackMob != null && this.isValidTarget() && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    public boolean canContinueToUse() {
        return this.isValidTarget() && (this.canUse() || !this.pathfinderMob.getNavigation().isDone()) && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    private boolean isValidTarget() {
        return this.pathfinderMob.getTarget() != null && this.pathfinderMob.getTarget().isAlive();
    }

    public void stop() {
        super.stop();
        this.pathfinderMob.setAggressive(false);
        this.pathfinderMob.setTarget(null);
        this.seeTime = 0;
        if (this.pathfinderMob.isUsingItem()) {
            this.pathfinderMob.stopUsingItem();
            this.crossbowAttackMob.setChargingCrossbow(false);
            this.pathfinderMob.getUseItem().set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        }
    }

    public void start() {
        super.start();
        this.pathfinderMob.setAggressive(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean shouldNavigateToTarget;
        boolean hasSeen;
        LivingEntity livingentity = this.pathfinderMob.getTarget();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.pathfinderMob.getSensing().hasLineOfSight((Entity)livingentity);
        boolean bl = hasSeen = this.seeTime > 0;
        if (hasLineOfSight != hasSeen) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distanceToTarget = this.pathfinderMob.distanceToSqr((Entity)livingentity);
        boolean bl2 = shouldNavigateToTarget = (distanceToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (shouldNavigateToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.pathfinderMob.getNavigation().moveTo((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.pathfinderMob.getRandom());
            }
        } else {
            this.updatePathDelay = 0;
            this.pathfinderMob.getNavigation().stop();
        }
        this.pathfinderMob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!shouldNavigateToTarget) {
                this.pathfinderMob.startUsingItem(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
                this.crossbowState = CrossbowState.CHARGING;
                this.crossbowAttackMob.setChargingCrossbow(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemstack;
            int i;
            if (!this.pathfinderMob.isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = this.pathfinderMob.getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(itemstack = this.pathfinderMob.getUseItem()), (LivingEntity)livingentity)) {
                this.pathfinderMob.releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + this.pathfinderMob.getRandom().nextInt(20);
                this.crossbowAttackMob.setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && hasLineOfSight) {
            this.crossbowAttackMob.performRangedAttack(livingentity, 1.0f);
            ItemStack itemStack1 = this.pathfinderMob.getItemInHand(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
            itemStack1.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

