/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.custom;

import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PathfinderMobRaw;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;

public class Fairy
extends PathfinderMobRaw {
    public static final String ID = "fairy";
    private static final CustomScale DEFAULT_SCALE = new CustomScale(0.4f);

    public Fairy(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, (Enum<?>)Parrot.Variant.GREEN);
    }

    public Fairy(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    protected PathNavigation createNavigation(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    @Override
    public CustomScale getDefaultModelScale() {
        return DEFAULT_SCALE;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.FAIRY;
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public Enum<?>[] getVariantTypes() {
        return VariantType.values();
    }

    @Override
    public Enum<?> getDefaultVariantType() {
        return VariantType.GREEN;
    }

    @Override
    public Enum<?> getVariantType(String name) {
        try {
            return VariantType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariantType();
        }
    }

    @Override
    public int getEntityDialogTop() {
        return -38;
    }

    @Override
    public int getEntityDialogScaling() {
        return 75;
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.PARROT_AMBIENT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.PARROT_DEATH);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.PARROT_HURT);
        soundDataSet.addSound(SoundType.EAT, SoundEvents.PARROT_EAT);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum VariantType {
        GREEN,
        RED,
        BLUE;

    }
}

